/*
 * ui_callback.c - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 * 
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
 
#include "ui_general.h"
#include <hildon/hildon.h>

/**
 * @brief fullscreen callback
 * @param
 * @return
**/
void callback_full(GtkAction* action, gpointer data)
{
    /* if is called from menu */
    if (action != NULL) {
        /* toggle fullscreen on/off */
        g_print("changing window state: ");
        ui_data->full = !ui_data->full;
        if (ui_data->full) {
            gtk_window_fullscreen(GTK_WINDOW(ui_data->window));
            g_print("fullscreen\n");
            /* activate toolbar in fullscreen mode */
            if (!ui_data->tool)
                gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ui_data->menu_tool), !ui_data->tool);
        } else {
            gtk_window_unfullscreen(GTK_WINDOW(ui_data->window));
            g_print("unfullscreen\n");
        }
    } else {
        /* if is called from toolbar */
        /* set "Fullscreen" item in menu active or not */       
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ui_data->menu_full), !ui_data->full);
    }

    /* handling window state */
    GSource* source = g_timeout_source_new(TIMEOUT);
    g_source_set_callback(source, G_CALLBACK(callback_scrn_stat), ui_data, NULL);
    g_source_attach(source, NULL);
    ui_data->source_time = source;
}

/**
 * @brief fullscreen toolbar button callback
 * @param
 * @return
**/
void callback_tool_full(GtkAction* action, gpointer data)
{
    callback_full(NULL, data);
}

/* CALLBACK TOOLBAR */
void callback_tool_tool(GtkAction* action, gpointer data)
{
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(ui_data->menu_tool), !ui_data->tool);
}

/**
 * @brief on changed screen state callback
 * @param
 * @return
**/
void callback_scrn_stat(gpointer data)
{
    //callback_fullscreen(NULL, data);
    int     width, height;
    //UIdata* ui_data = data;
    gtk_window_get_size(GTK_WINDOW(ui_data->window), &width, &height);
    g_print("width=%d; height=%d\n", width, height);
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    //callback_fullscreen(NULL, data);
}

/**
 * @brief go to page callback
 * @param
 * @return
**/
void callback_goto(GtkWidget* widget, int i)
{    
    //UIdata* ui_data = ui_data_ptr;
    //UIdata* ui_data = NULL;
    //ui_data = ( UIdata* )data;
    //g_assert(ui_data != NULL);
    //ui_data->prev = gtk_notebook_get_current_page(GTK_NOTEBOOK(ui_data->notebook));
    g_print("%d / %d\n", ui_data->prev, ui_data->page);
    
    gtk_window_set_title (GTK_WINDOW (ui_data->window), ui_data->str_page[i]);
    gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->notebook), i);
    ui_data->prev = ui_data->page;
    ui_data->page = i;
    if (ui_data->page == 2 && !ui_data->empty_profile) {
        ui_data->empty_profile = FALSE;
        callback_button_profile_update(NULL, NULL);
    }
}

/**
 * @brief help window callback
 * @param
 * @return
**/
void callback_help(GtkAction* action, gpointer data)
{    
    //UIdata* ui_data = NULL;
    //ui_data = ( UIdata* )data;
    g_assert(ui_data != NULL);
    //ui_data = data;
    g_print("in callback_help: help is %d\n", ui_data->help);
    if (ui_data->help == FALSE){
        ui_init_help();
    }
    g_print("in callback_help: help is %d\n", ui_data->help);
    
    gtk_window_deiconify(GTK_WINDOW(ui_data->window_help));
    gtk_window_unstick(GTK_WINDOW(ui_data->window_help));
    gtk_window_maximize(GTK_WINDOW(ui_data->window_help));
    gtk_window_set_keep_above(GTK_WINDOW(ui_data->window_help), TRUE);
    gtk_widget_show(GTK_WIDGET(ui_data->window_help));
}

/**
 * @brief close help window callback
 * @param
 * @return
**/
void callback_help_close(GtkWidget* window, gpointer data)
{
    //UIdata* ui_data = NULL;
    //ui_data = ( UIdata* )data;
    g_assert(ui_data != NULL);
    //UIdata* ui_data = data;
    ui_data->help = FALSE;
    gtk_window_deiconify(GTK_WINDOW(ui_data->window));
    gtk_window_unstick(GTK_WINDOW(ui_data->window));
    gtk_window_maximize(GTK_WINDOW(ui_data->window));
    g_print("in callback_help_close: help is %d\n", ui_data);
}

/**
 * @brief toolbar callback
 * @param
 * @return
**/
void callback_tool(GtkAction* action, gpointer data)
{
    g_print("tool\n");
    //UIdata* ui_data = NULL;
    //ui_data = ( UIdata* )data;
    //g_assert(ui_data != NULL);
    ui_data->tool = !ui_data->tool;
    if(ui_data->tool){
        gtk_widget_show_all(ui_data->toolbar);
    } else {
        gtk_widget_hide(ui_data->toolbar);
    }
}

/**
 * @brief edit detail field callback
 * @param
 * @return
**/
void callback_detail_edit(GtkWidget* container, gpointer value)
{
    //tkWidget* label = value;
    //gchar str = gtk_label_get_text(GTK_LABEL(label));
    g_print("callback detail edit\n");
    //g_print("%s\n", &value);
    GList* widget = gtk_container_get_children(GTK_CONTAINER(container));
    widget = gtk_container_get_children(GTK_CONTAINER(widget->data));
    GtkWidget* label = widget->data;
    //GList* values = widgets->next;
    //widgets = gtk_container_get_children(GTK_CONTAINER(widgets->data));
    //values = gtk_container_get_children(GTK_CONTAINER(values->data));
    gchar* str;
    str = gtk_widget_get_name(GTK_WIDGET(label));
    g_print("%s ",str);  
    str = gtk_label_get_text(GTK_LABEL(label));    
    g_print("%s\n",str);
    
    //gtk_label_set_markup(GTK_LABEL(ui_data->entry_labl),g_strconcat(MARKUP1,gtk_widget_get_name(GTK_WIDGET(label)),": ",PUKRAM1,NULL));
    
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new( FALSE, 0 ); 
    GtkWidget* caption;    
    //GtkWidget* label;
    GtkWidget* button;
    GtkWidget* entry;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), g_strconcat("Enter ",gtk_widget_get_name(GTK_WIDGET(label)),NULL));
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    window = GTK_WINDOW(dialog);

    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_with_label(STR_SAVE);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT );
    
    gtk_container_add( GTK_CONTAINER( dialog ), vbox );

    entry = gtk_entry_new();
    gtk_widget_set_usize (entry, -1, MIN_HEIGHT);
    //GtkWidget* entry_date = gtk_calendar_new();
    
    gtk_entry_set_text(GTK_ENTRY(entry), gtk_label_get_text(GTK_LABEL(label)));

    //gtk_container_add( GTK_CONTAINER( dialog ), entry );
    gtk_container_add( GTK_CONTAINER( dialog->vbox ), entry);
    //gtk_container_add( GTK_CONTAINER( dialog->vbox ), entry_date);
    //gtk_widget_set_size_request( GTK_WIDGET( dialog ), -1, -1 );
    gtk_widget_show_all( GTK_WIDGET( dialog ) );

    /* Run dialog cycle */
    result = gtk_dialog_run(dialog);

    if( result == GTK_RESPONSE_ACCEPT ) {
        //hildon_banner_show_information( NULL, NULL, gtk_entry_get_text(GTK_ENTRY(entry)) ); 
        gtk_label_set_text(GTK_LABEL(label), gtk_entry_get_text(GTK_ENTRY(entry))); 
    }
    
    gtk_widget_destroy( GTK_WIDGET( dialog ) );
    
    //ui_data->prev = ui_data->page;
    //callback_goto(NULL, 3);    
}

/**
 * @brief on combobox changed value callback
 * @param
 * @return
**/
void callback_combo_changed(GtkComboBox* widget, gpointer user_data)
{
    g_print("%s: ", (gchar*)user_data);
    g_print("%s\n", gtk_combo_box_get_active_text(GTK_COMBO_BOX(widget)));
    
    xmlXPathObject* obj = xpath( g_strconcat("//TransitData/Content/Response/Params/select[@name='", (gchar*)user_data,"']", NULL), ui_data->ui_request);
    
    if (obj->nodesetval != NULL) {
    
        xmlNodePtr node = xmlNewDocNode(ui_data->ui_request, NULL, BAD_CAST TYPE_STRNG, 
                                        gtk_combo_box_get_active_text(GTK_COMBO_BOX(widget)));
                                        
        xmlSetProp(node, "selected", "1");
    
        xmlUnlinkNode(obj->nodesetval->nodeTab[0]->children);
        xmlFreeNodeList(obj->nodesetval->nodeTab[0]->children);
        obj->nodesetval->nodeTab[0]->children = NULL;
    
        xmlAddChild(obj->nodesetval->nodeTab[0], node);
    }
    else {
        g_debug("callback_date error obj is null");    
    }
}

/**
 * @brief edit date field callback
 * @param
 * @return
**/
void callback_date_edit(GtkWidget* container, gpointer value)
{
    GList* widget = gtk_container_get_children(GTK_CONTAINER(container));
    widget = gtk_container_get_children(GTK_CONTAINER(widget->data));
    GtkWidget* label = widget->data;

    gchar** numbers = g_strsplit(gtk_label_get_text(GTK_LABEL(label)), ".", 3);
    gint y = atoi(numbers[2]);
    gint m = atoi(numbers[1]);
    gint d = atoi(numbers[0]);
    
    GtkWidget* popup = hildon_calendar_popup_new (GTK_WINDOW (ui_data->window), y, m, d);
    int result = gtk_dialog_run (GTK_DIALOG (popup));
    switch (result) {
        case GTK_RESPONSE_OK:
        case GTK_RESPONSE_ACCEPT:
        hildon_calendar_popup_get_date (HILDON_CALENDAR_POPUP (popup), &y, &m, &d);
    }
    gtk_widget_destroy(popup);
    g_print("%d.%d.%d\n", d, m, y);
    gchar* str_d;
    gchar* str_m;
    gchar* str_y;
    
    struct tm tm_date;
    tm_date.tm_mday = d;
    tm_date.tm_mon = m - 1;
    tm_date.tm_year = y - 1900;
    gchar* str_date = malloc(sizeof(gchar)*11);
    strftime(str_date, 11, "%d.%m.%Y\0", &tm_date);  

    gtk_label_set_text(GTK_LABEL(label),str_date);
    
    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/date[@name='Birthday']", ui_data->ui_request);
    
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        g_debug("callback_date - %s", obj->nodesetval->nodeTab[0]->name);
        xmlNodeSetContent(obj->nodesetval->nodeTab[0],
                        g_strconcat(str_date,NULL));
    }
    else {
        g_debug("callback_date error obj is null");    
    }
    
    //xmlDocDump(stdout, ui_data->ui_request);
    
}

/**
 * @brief get profile callback
 * @param
 * @return
**/
void callback_button_profile_get(GtkWidget* button, gpointer data)
{
    //UIdata* ui_data = NULL;
    //g_print("callback_button_profile_get KERNEL->SEND\n");
    //g_source_unref(ui_data->source_time);
    //g_source_destroy(ui_data->source_time);
    
    //ui_data = ( UIdata* )data;
    //g_assert(ui_data != NULL);
    g_print("putting data in kernel\n");
    kernel->send(xmlParseDoc(g_strdup("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"profile\" function = \"getProfile\"><Params></Params></Request></Content></TransitData>")), NULL, NULL);
    g_print("data was put in kernel\n");
}

/**
 * @brief get friends list callback
 * @param
 * @return
**/
void callback_button_friends_get(GtkWidget* button, gpointer data)
{
    int from = FRIENDS_PER_PAGE*ui_data->page_frds;
    int to = FRIENDS_PER_PAGE*(ui_data->page_frds + 1);
    gchar* str_sort;
    if(ui_data->ascending) {
        str_sort = g_strdup("asc");
    } else {
        str_sort = g_strdup("desc");
    }
    /* correct number of friends */
    if (to >  ui_data->num_frds) to =  ui_data->num_frds;
    //gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), g_strdup_printf("%d - %d / %d\n", from + 1, to, ui_data->num_frds));
    if (to <  FRIENDS_PER_PAGE) to =  FRIENDS_PER_PAGE;
    //g_print(g_strdup_printf("%d",from)));
    g_print("callback_button_friends_get KERNEL->SEND\n");
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"friends\" function = \"getListFriends\"><Params From=\"",g_strdup_printf("%d",from),\
    "\" To=\"",g_strdup_printf("%d",to),"\" Sort=\"",str_sort,"\"/></Request></Content></TransitData>", NULL))), NULL, NULL);
    g_print("GETTING FRIENDS FROM %d to %d\n", from + 1, to + 1);
}

/**
 * @brief sort friends lsit
 * @param
 * @return
**/
void callback_button_friends_sort(GtkWidget* button, gpointer data)
{
    ui_data->ascending = !ui_data->ascending;
    callback_button_friends_get(NULL, NULL);
}

/**
 * @brief filter
 * @param
 * @return
**/
void callback_friends_filter(gchar* str_filter)
{
    if (str_filter != NULL) {
        if (strlen(str_filter) > 0) {
            ui_data->friends_filter = TRUE;
        } else {
            ui_data->friends_filter = FALSE;
        }
    } else {
        ui_data->friends_filter = FALSE;
    }
    
    if (ui_data->friends_filter) {
        gtk_widget_hide(ui_data->box_friends_navi);
        gtk_label_set_text(GTK_LABEL(ui_data->label_friends_filter), g_strconcat(STR_RSLT, " \"", str_filter, "\"", NULL));
        gtk_widget_show_all(ui_data->box_friends_result);
    } else {
        gtk_widget_show_all(ui_data->box_friends_navi);
        gtk_widget_hide(ui_data->box_friends_result);
    }
}

/**
 * @brief update friends lsit in database callback
 * @param
 * @return
**/
void callback_button_friends_result(GtkWidget* button_cb, gpointer data)
{
    callback_friends_filter(NULL);
    callback_button_friends_get(NULL, NULL);
}

/**
 * @brief update friends lsit in database callback
 * @param
 * @return
**/
void callback_button_friends_update(GtkWidget* button, gpointer data)
{
    g_print("!!!\t CALLBACK FRIENDS UPDATE\t !!!\n");
    kernel->send(xmlParseDoc(g_strdup("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"friends\" function = \"updateListFriends\"><Params></Params></Request></Content></TransitData>")), NULL, NULL);
    g_print("data was put in kernel\n");
}

/**
 * @brief prev page of a friends list
 * @param
 * @return
**/
void callback_button_friends_page_prev(GtkWidget* button, gpointer data)
{
    if (ui_data->page_frds > 0) {
        ui_data->page_frds--;
    }
    int from = ui_data->page_frds * FRIENDS_PER_PAGE;
    int to = (ui_data->page_frds + 1) * FRIENDS_PER_PAGE;
    if (to >  ui_data->num_frds) to =  ui_data->num_frds;
    //gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), g_strdup_printf("%d - %d / %d\n", from + 1, to, ui_data->num_frds));
    callback_button_friends_get(NULL, NULL);
}

/**
 * @brief next page of a friends list
 * @param
 * @return
**/
void callback_button_friends_page_next(GtkWidget* button, gpointer data)
{
    if (ui_data->page_frds < ui_data->num_frds / FRIENDS_PER_PAGE) {
        ui_data->page_frds++;
    }
    int from = ui_data->page_frds * FRIENDS_PER_PAGE;
    int to = (ui_data->page_frds + 1) * FRIENDS_PER_PAGE;
    if (to >  ui_data->num_frds) to =  ui_data->num_frds;
    //gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), g_strdup_printf("%d - %d / %d\n", from + 1, to, ui_data->num_frds));
    callback_button_friends_get(NULL, NULL);
}

/**
 * @brief the 1st page of a friends list
 * @param
 * @return
**/
void callback_button_friends_page_frst(GtkWidget* button, gpointer data)
{
    ui_data->page_frds = 0;
    callback_button_friends_get(NULL, NULL);
}

/**
 * @brief the last page of a friends list
 * @param
 * @return
**/
void callback_button_friends_page_last(GtkWidget* button, gpointer data)
{
    ui_data->page_frds = ui_data->num_frds / FRIENDS_PER_PAGE;
    callback_button_friends_get(NULL, NULL);
}



/**
 * @brief get messages list callback
 * @param
 * @return
**/
void callback_button_messages_get(GtkWidget* button, gpointer data)
{
    //UIdata* ui_data = NULL;
    
    //ui_data = ( UIdata* )data;
    //g_assert(ui_data != NULL);
    gchar* str_msgs_box;
    if (ui_data->msgs_box == INBOX) {
        str_msgs_box = g_strdup("Inbox");
    } else {
        str_msgs_box = g_strdup("Outbox");
    }
    
    /* correct number of friends */
    int from = MESSAGES_PER_PAGE*ui_data->page_msgs;
    int to = MESSAGES_PER_PAGE*(ui_data->page_msgs + 1);
    if (to >  ui_data->num_msgs) to =  ui_data->num_msgs;
    //gtk_label_set_text(GTK_LABEL(ui_data->label_messages_page), g_strdup_printf("%d - %d / %d\n", from + 1, to, ui_data->num_msgs));
    if (to <  MESSAGES_PER_PAGE) to =  MESSAGES_PER_PAGE;
    
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"messages\" function = \"get",str_msgs_box,"Messages\"><Params From=\"",g_strdup_printf("%d",from),\
    "\" To=\"",g_strdup_printf("%d",to),"\"></Params></Request></Content></TransitData>",NULL))), NULL, NULL);
    //g_print("data was put in kernel\n");
}

/**
 * @brief reply on a message callback
 * @param
 * @return
**/
void callback_message_reply(GtkWidget* container, GdkEventButton* event, gpointer data)
{
    Message* msg = data;
    //g_print("!!!!!!!\t%s\n", (gchar*)msg->str_text);
    gtk_widget_hide(GTK_WIDGET(ui_data->box_messages));
    
    /* REMOVE MESSAGES LIST */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_message_reply));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    GtkWidget* box_reply = ui_init_message_reply(data);
    gtk_box_pack_start(GTK_BOX(ui_data->box_message_reply), box_reply, TRUE, TRUE, 0);
    gtk_widget_show_all(GTK_WIDGET(ui_data->box_message_reply));
}


/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
gpointer ui_init_message_reply(gpointer ptr_msg)
{
    Message* msg = ptr_msg;
    Friend* friend = g_new0(Friend, 1);
    friend->str_id = msg->str_sender_id;
    GtkWidget* container = gtk_vbox_new(FALSE, 0);
    GtkWidget* hbox_header = gtk_hbox_new(FALSE, 0);
    gtk_widget_set_usize(hbox_header, -1, MIN_HEIGHT);
    
    GtkWidget* label_sndr = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(label_sndr), g_strconcat(MARKUP, " from: ", PUKRAM, msg->str_sender_name, NULL));
    GtkWidget* label_time = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(label_time), g_strconcat(MARKUP, msg->str_date, "  ", msg->str_time , PUKRAM, NULL));
    
    GtkWidget* separator = gtk_hseparator_new();
    
    GtkWidget* label_text = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP1, msg->str_text, PUKRAM, NULL));
    gtk_label_set_justify(GTK_LABEL(label_text), GTK_JUSTIFY_FILL);
    gtk_label_set_line_wrap(GTK_LABEL(label_text), TRUE);
    gtk_label_set_single_line_mode(GTK_LABEL(label_text), FALSE);
    
    GtkWidget* alignment_label_sndr = gtk_alignment_new(0, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label_sndr), label_sndr);
    GtkWidget* alignment_label_time = gtk_alignment_new(1, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label_time), label_time);
    
    GtkWidget* alignment_label_text = gtk_alignment_new(0, 0, 0, 0);
    gtk_alignment_set_padding (GTK_ALIGNMENT(alignment_label_text), PADDING, PADDING, PADDING, PADDING);
    gtk_container_add(GTK_CONTAINER(alignment_label_text), label_text);
    
    GtkWidget* hbox_buttons = gtk_hbox_new(TRUE, 0);
    gtk_widget_set_usize(hbox_buttons, -1, MIN_HEIGHT);
    GtkWidget* button_back = gtk_button_new_with_label(g_strconcat(STR_BACK, STR_TO, STR_MSGS, NULL));
    GtkWidget* button_rply = gtk_button_new_with_label(STR_RPLY);
    
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    gtk_scrolled_window_add_with_viewport(GTK_WINDOW(scrollable), alignment_label_text);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    GtkWidget* container_sndr = gtk_event_box_new();
    gtk_container_add(GTK_CONTAINER(container_sndr), alignment_label_sndr);
    
    gtk_box_pack_start(GTK_BOX(hbox_header), container_sndr, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_header), alignment_label_time, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_buttons), button_back, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_buttons), button_rply, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(container), hbox_header, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(container), separator, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(container), scrollable, TRUE, TRUE, 0);
    
    g_signal_connect(G_OBJECT(button_back), "clicked", G_CALLBACK(callback_message_reply_cancel), NULL);
    g_signal_connect(G_OBJECT(button_rply), "clicked", G_CALLBACK(callback_message_reply_entry), ptr_msg);
    g_signal_connect(G_OBJECT(container_sndr), "button_press_event", G_CALLBACK(callback_message_profile), (gpointer)friend);
    gtk_box_pack_start(GTK_BOX(container), hbox_buttons, FALSE, FALSE, 0);
        
    return container;
}

/**
 * @brief prev page of a messages list
 * @param
 * @return
**/
void callback_button_msgs_page_prev(GtkWidget* button, gpointer data)
{
    if (ui_data->page_msgs > 0) {
        ui_data->page_msgs--;
    }
    int from = ui_data->page_msgs * MESSAGES_PER_PAGE;
    int to = (ui_data->page_msgs + 1) * MESSAGES_PER_PAGE;
    if (to >  ui_data->num_msgs) to =  ui_data->num_msgs;
    callback_button_messages_get(NULL, NULL);
}

/**
 * @brief next page of a messages list
 * @param
 * @return
**/
void callback_button_msgs_page_next(GtkWidget* button, gpointer data)
{
    if (ui_data->page_msgs < ui_data->num_msgs / MESSAGES_PER_PAGE) {
        ui_data->page_msgs++;
    }
    int from = ui_data->page_msgs * MESSAGES_PER_PAGE;
    int to = (ui_data->page_msgs + 1) * MESSAGES_PER_PAGE;
    if (to >  ui_data->num_msgs) to =  ui_data->num_msgs;
    callback_button_messages_get(NULL, NULL);
}

/**
 * @brief switch inbox / sent messages
 * @param
 * @return
**/
void callback_combo_msgs_changed(GtkComboBox* widget, gpointer user_data)
{
	ui_data->page_msgs = 0;
    int msgs = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
    if (msgs == 0 && ui_data->msgs_box != INBOX) {
        ui_data->msgs_box = INBOX;
        callback_button_messages_get(NULL, NULL);
    }
    if (msgs == 1 && ui_data->msgs_box == INBOX) {
        ui_data->msgs_box = SENT;
        callback_button_messages_get(NULL, NULL);
    }
    //g_print("%s: ", (gchar*)user_data);
}

/**
 * @brief view friend's profile from message form
 * @param
 * @return
**/
void callback_message_profile(GtkWidget* container, GdkEventButton* event, gpointer user_data)
{
    callback_friend(ui_data->box_friend, NULL, user_data);
}


/**
 * @brief click on a friend callback
 * @param
 * @return
**/
void callback_friend(GtkWidget* container, GdkEventButton* event, gpointer value)
{
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"profile\" function = \"getProfile\"><Params id=\"", (gchar*)value, "\"></Params></Request></Content></TransitData>",NULL))), NULL, NULL);
    // execute on friend's profile received
    ui_init_friend_profile(container, value);

}

/**
 * @brief update messages in database
 * @param
 * @return
**/
void callback_button_messages_update(GtkWidget* button, gpointer data)
{
    gchar* str_msgs_box;
    if (ui_data->msgs_box == INBOX) {
        str_msgs_box = g_strdup("Inbox");
    } else {
        str_msgs_box = g_strdup("Outbox");
    }
    
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"messages\" function = \"update", str_msgs_box, "Messages\"><Params></Params></Request></Content></TransitData>",NULL))), NULL, NULL);
}

/**
 * @brief cancel reply on a message callback
 * @param
 * @return
**/
void callback_message_reply_cancel(GtkWidget* button, gpointer data)
{
    gtk_widget_show_all(GTK_WIDGET(ui_data->box_messages));
    gtk_widget_hide(GTK_WIDGET(ui_data->box_message_reply));
}

/**
 * @brief reply on a message callback
 * @param
 * @return
**/
void callback_message_reply_entry(GtkWidget* button_cb, gpointer ptr_msg)
{
    Message* msg = ptr_msg;
    GtkWidget* entry;
    
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new(FALSE, 0); 
    GtkWidget* caption;    
    GtkWidget* label;
    GtkWidget* button;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), STR_NMSG);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    window = GTK_WINDOW(dialog);

    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_with_label(STR_SEND);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT );
    
    //gtk_container_add(GTK_CONTAINER(dialog), vbox);
    
    //label = gtk_label_new(STR_NMSG);
    entry = gtk_text_view_new ();
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (entry), TRUE);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (entry), TRUE);
    gtk_widget_set_usize(entry, MIN_WIDTH * 2, MIN_HEIGHT * 2);

    gtk_container_add( GTK_CONTAINER( dialog->vbox ), entry);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );

    /* Run dialog cycle */
    result = gtk_dialog_run(dialog);

    if( result == GTK_RESPONSE_ACCEPT ) {
        GtkTextIter start;
        GtkTextIter end;
        GtkTextBuffer* text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entry));
        gtk_text_buffer_get_start_iter(text_buffer, &start);
        gtk_text_buffer_get_end_iter(text_buffer, &end);
        gchar* str_msg = gtk_text_buffer_get_text(text_buffer, &start, &end, FALSE);
        
        
        CURL* curl;
        gchar* str_to_send = curl_easy_escape(curl, str_msg, 0);
        g_print("\n%s\n",str_to_send);
        
        kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
        type=\"data\"><SourceID>ui</SourceID><TargetID>vkontakte</TargetID><Content><Request class=\"messages\" function = \"sendMessage\">\
        <Params id=\"", msg->str_sender_id, "\"><string name=\"text\">", str_to_send , "</string></Params></Request></Content></TransitData>", NULL, NULL))), NULL, NULL);
    }
    
    gtk_widget_destroy(GTK_WIDGET(dialog));
}

/**
 * @brief send a message callback
 * @param
 * @return
**/
void callback_message_reply_send(GtkWidget* button, gpointer ptr_msg)
{

}

/**
 * @brief init friend's profile form
 * @param
 * @return
**/
void ui_init_friend_profile(GtkWidget* container, gpointer ptr_str_id)
{
    /* REMOVE FRIEND'S PROFILE */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_friend));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }    
    //FIXME
    ui_data->box_friends_profile = gtk_vbox_new(FALSE, 0);
    
    GtkWidget* navi = ui_init_friend_tools(ptr_str_id);
    
    /* ICONS OF SERVICES */
    int i = 0;
    GtkWidget* box_service = gtk_hbox_new(FALSE, 0);
    GList* node;
    msa_driver_info* info;
    GtkWidget* icon_service[ui_data->num_srvs];
    GtkWidget* alignment[ui_data->num_srvs];
    GtkWidget* combo = gtk_combo_box_new_text();
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        info = (msa_driver_info*)node->data;
        if (info->pic == NULL){
            icon_service[i] = gtk_image_new_from_file(IMG_SRVC);
        } else {
            int size;
            guchar* buff = g_base64_decode((gchar*)info->pic, &size);
            GdkPixbufLoader* pbloader;
            pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
            gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
            gdk_pixbuf_loader_close (pbloader, NULL);
            int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
            int height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
            GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
            icon_service[i] = gtk_image_new_from_pixbuf(pixbuff);
        }
        gtk_box_pack_start(GTK_BOX(box_service), icon_service[i], FALSE, FALSE, PADDING);
        gtk_combo_box_append_text(GTK_COMBO_BOX(combo), info->name);
        i++;
    }
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo), 0);
    gtk_box_pack_start (GTK_BOX (box_service), combo, TRUE, TRUE, PADDING);
    GtkWidget* separator = gtk_hseparator_new();
    /* END ICONS */
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friend), box_service, FALSE, FALSE, PADDING);
    gtk_box_pack_start (GTK_BOX (ui_data->box_friend), separator, FALSE, FALSE, 0);
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friend), ui_data->box_friends_profile, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->box_friend), navi, FALSE, TRUE, 0);
    gtk_widget_set_usize(GTK_WIDGET(navi), -1, MIN_HEIGHT);
    gtk_widget_hide(GTK_WIDGET(ui_data->box_friends));
    gtk_widget_show_all(GTK_WIDGET(ui_data->box_friend));
    gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->tasks), 1);
    return;
}

/**
 * @brief create widget with list of drivers
 * @param
 * @return
**/
gpointer ui_init_friend_tools(gpointer ptr_str_id)
{
    GtkWidget* box = gtk_hbox_new(TRUE, 0);
    GtkWidget* button_back = gtk_button_new_with_label(g_strconcat(STR_BACK, STR_TO, STR_FRDS, NULL));
    GtkWidget* button_updt = gtk_button_new_with_label(STR_UPDT);
    GtkWidget* button_join = gtk_button_new_with_label(STR_JOIN);
    gtk_widget_set_sensitive(button_join, FALSE);
    
    gtk_box_pack_start (GTK_BOX(box), button_back, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(box), button_updt, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(box), button_join, TRUE, TRUE, 0);
    gtk_widget_set_sensitive(button_join, FALSE);

    g_signal_connect(G_OBJECT(button_back), "clicked", G_CALLBACK(callback_button_friends), NULL);
    g_signal_connect(G_OBJECT(button_updt), "clicked", G_CALLBACK(callback_button_friends_profile_update), ptr_str_id);
    g_signal_connect(G_OBJECT(button_join), "clicked", G_CALLBACK(callback_button_friends_profile_join), ptr_str_id);
    
    return box;    
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_friends_profile_update(GtkWidget* button, gpointer data)
{
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"profile\" function = \"updateProfile\"><Params id=\"",(gchar*)data,"\"></Params></Request></Content></TransitData>",NULL))), NULL, NULL);
}

/**
 * @brief join one profile with another
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_friends_profile_join(GtkWidget* button, gpointer data)
{
    g_print(g_strconcat("\tJOIN PROFILE ", (gchar*)data, " WITH...", NULL));
    //FIXME
    /*kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"profile\" function = \"getProfiles\"><Params/></Request></Content></TransitData>", NULL))), NULL, NULL);*/
    callback_friends_join(NULL, NULL);
}

/**
 * @brief join profiles dialog
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_friends_join(GtkWidget* button_cb, gpointer data)
{    
    GtkWindow* window;
    GtkDialog* dialog;
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL);
    
    GtkWidget* hbox = gtk_hbox_new(FALSE, 0); 
    GtkWidget* vbox_chck = gtk_vbox_new(TRUE, PADDING);
    GtkWidget* vbox_name = gtk_vbox_new(TRUE, PADDING);
    GtkWidget* vbox_icon = gtk_vbox_new(TRUE, PADDING);
    GtkWidget* caption;    
    GtkWidget* label;
    GtkWidget* button;
    GtkWidget* check;
    GtkWidget* icon;
    GtkWidget* alignment_label;
    GdkPixbufLoader* pbloader;
    
    int result;
    int i;
    
    gchar* str_serv;
    guchar* str_icon;

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), STR_SLCT" "STR_PR2J);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    //window = GTK_WINDOW(dialog);

    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_with_label(STR_OK__);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT );
    
    //gtk_container_add( GTK_CONTAINER(dialog), vbox);
    gtk_scrolled_window_add_with_viewport(GTK_WINDOW(scrollable), hbox);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(hbox), vbox_chck, FALSE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(hbox), vbox_name, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), vbox_icon, FALSE, TRUE, PADDING);
    
    //FIXME
    
    GList* node;
    msa_driver_info* info;
    int size;
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        info = (msa_driver_info*)node->data;
        str_serv = g_strdup(info->name); 
        if (info->pic != NULL){
            str_icon = g_base64_decode((gchar*)info->pic, &size);
        }
    }    
    
    for (i = 0; i < 100; i++) {
        check = gtk_check_button_new();
        gtk_box_pack_start (GTK_BOX (vbox_chck), check, FALSE, FALSE, 0);
        label = gtk_label_new(g_strdup_printf("profile %d", i));
        alignment_label = gtk_alignment_new(0, 0.5, 0, 0); 
        gtk_container_add(GTK_CONTAINER(alignment_label), label);
        gtk_box_pack_start (GTK_BOX (vbox_name), alignment_label, FALSE, FALSE, 0);
        pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
        gdk_pixbuf_loader_write(pbloader, str_icon, size, NULL);
        gdk_pixbuf_loader_close (pbloader, NULL);
        int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
        GdkPixbuf* pixbuf = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, width, GDK_INTERP_BILINEAR);
        icon = gtk_image_new_from_pixbuf(pixbuf);
        gtk_box_pack_start (GTK_BOX (vbox_icon), icon, FALSE, FALSE, 0);
    }
    
    gtk_widget_set_usize(scrollable, 400, 300);    
    //gtk_widget_set_usize (entry, -1, MIN_HEIGHT);
    gtk_container_add( GTK_CONTAINER( dialog->vbox ), scrollable);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );
    result = gtk_dialog_run(dialog);
    if( result == GTK_RESPONSE_ACCEPT ) {
        //gchar* str = gtk_entry_get_text(GTK_ENTRY(entry));
        //kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
        type=\"data\"><SourceID>ui</SourceID>\
        <TargetID>db</TargetID>\
        <Content><Request class=\"friends\" function = \"getListFriends\"><Params Filter=\"",str,"\"/></Request></Content></TransitData>", NULL))), NULL, NULL);
        
    }
    
    gtk_widget_destroy( GTK_WIDGET( dialog ) );
}

/**
 * @brief find friends
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_friends_find(GtkWidget* button_cb, gpointer data)
{    
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new( FALSE, 0 ); 
    GtkWidget* caption;    
    GtkWidget* label;
    GtkWidget* button;
    GtkWidget* entry;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), STR_FIND);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    //window = GTK_WINDOW(dialog);

    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_with_label(STR_FIND);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT );
    
    //gtk_container_add( GTK_CONTAINER(dialog), vbox);

    entry = gtk_entry_new();
    gtk_widget_set_usize (entry, -1, MIN_HEIGHT);
    gtk_container_add( GTK_CONTAINER( dialog->vbox ), entry);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );
    result = gtk_dialog_run(dialog);
    if( result == GTK_RESPONSE_ACCEPT ) {
        gchar* str = gtk_entry_get_text(GTK_ENTRY(entry));
        kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
        type=\"data\"><SourceID>ui</SourceID>\
        <TargetID>db</TargetID>\
        <Content><Request class=\"friends\" function = \"getListFriends\"><Params Filter=\"",str,"\"/></Request></Content></TransitData>", NULL))), NULL, NULL);
        
    }
    
    gtk_widget_destroy( GTK_WIDGET( dialog ) );
}

/**
 * @brief send a message to a friend
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_friend_send_message(GtkWidget* button_cb, gpointer ptr_str_id)
{
    GtkWidget* entry;
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new(FALSE, 0); 
    GtkWidget* caption;    
    GtkWidget* label;
    GtkWidget* button;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), STR_NMSG);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    window = GTK_WINDOW(dialog);

    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);
    button = gtk_button_new_with_label(STR_SEND);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT );
    
    //gtk_container_add(GTK_CONTAINER(dialog), vbox);
    
    //label = gtk_label_new(STR_NMSG);
    entry = gtk_text_view_new ();
    gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (entry), TRUE);
    gtk_text_view_set_editable (GTK_TEXT_VIEW (entry), TRUE);
    gtk_widget_set_usize(entry, MIN_WIDTH * 2, MIN_HEIGHT * 2);

    gtk_container_add( GTK_CONTAINER( dialog->vbox ), entry);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );

    /* Run dialog cycle */
    result = gtk_dialog_run(dialog);

    if (result == GTK_RESPONSE_ACCEPT) {
        GtkTextIter start;
        GtkTextIter end;
        GtkTextBuffer* text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entry));
        gtk_text_buffer_get_start_iter(text_buffer, &start);
        gtk_text_buffer_get_end_iter(text_buffer, &end);
        gchar* str_msg = gtk_text_buffer_get_text(text_buffer, &start, &end, FALSE);
        CURL* curl;
        gchar* str_to_send = curl_easy_escape(curl, str_msg, 0);
        g_print("\n%s\n",str_to_send);
        
        kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
        type=\"data\"><SourceID>ui</SourceID><TargetID>vkontakte</TargetID><Content><Request class=\"messages\" function = \"sendMessage\">\
        <Params id=\"",(gchar*)ptr_str_id, "\"><string name=\"text\">", str_to_send , "</string></Params></Request></Content></TransitData>", NULL))), NULL, NULL);
    }
    
    gtk_widget_destroy(GTK_WIDGET(dialog));
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_friends(GtkWidget* button, gpointer data)
{
    gtk_widget_hide(GTK_WIDGET(ui_data->box_friend));
    gtk_widget_show_all(GTK_WIDGET(ui_data->box_friends));
    if (ui_data->friends_filter) {
        gtk_widget_hide(GTK_WIDGET(ui_data->box_friends_navi));
    } else {
        gtk_widget_hide(GTK_WIDGET(ui_data->box_friends_result));
    }
}

/**
 * @brief get friend's profile from database 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_friend_get(GtkWidget* button, gpointer data)
{
    kernel->send(xmlParseDoc(g_strdup(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
        type=\"data\"><SourceID>ui</SourceID>\
        <TargetID>db</TargetID>\
        <Content><Request class=\"profile\" function = \"getProfile\"><Params id=\"", (gchar*)data, "\"></Params></Request></Content></TransitData>",NULL))), NULL, NULL);
}

/**
 * @brief update profile
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_profile_update(GtkWidget* button, gpointer data)
{
    kernel->send(xmlParseDoc(g_strdup("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>db</TargetID>\
    <Content><Request class=\"profile\" function = \"updateProfile\"><Params></Params></Request></Content></TransitData>")), NULL, NULL);
    g_print("data was put in kernel\n");
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_profile_save(GtkWidget* button, gpointer data)
{
    xmlNodePtr node;
    
    /** treansit request to driver **/
    xmlDocPtr req_drv = xmlCopyDoc(ui_data->ui_request, 1);

    /** change name node, class, function **/
    xmlXPathObject* obj = xpath("//TransitData/Content/Response", req_drv);
    if (obj->nodesetval->nodeNr != 0) {
        node = obj->nodesetval->nodeTab[0];
        xmlNodeSetName(node, "Request");
        xmlSetProp(node, "class", PROFILE);
        xmlSetProp(node, "function", SET_PROFILE);
    }
    else {
        g_debug("callback_button_profile_save: save_request error response obj is null");    
    }
    
    /** change source id **/
    obj = xpath(SOURCE_TAG_XPATH, req_drv);
    if (obj->nodesetval->nodeNr != 0) {
        node = obj->nodesetval->nodeTab[0];
        xmlNodeSetContent(node, UI_ID);
    }
    else {
        g_debug("callback_button_profile_save: save_request error source obj is null");    
    }
    
    /** create target id **/
    obj = xpath(TARGET_TAG_XPATH, req_drv);
    if (obj->nodesetval->nodeNr != 0) {
        node = obj->nodesetval->nodeTab[0];
        xmlNodeSetContent(node, "vkontakte");
    }
    else {
        g_debug("callback_button_profile_save: save_request error source obj is null");
        //FIXME
        node = xmlNewDocNode(req_drv, NULL, TARGET_NODE, "vkontakte");
        xmlNodePtr root = xmlDocGetRootElement(req_drv);
        xmlAddChild(root, node);    
    }
    
    //xmlDocDump(stdout, ui_data->ui_request);
    kernel->send(req_drv, NULL, NULL);
    
    //UIdata* ui_data = NULL;
    
    //ui_data = ( UIdata* )data;
    //g_assert(ui_data != NULL);
    //g_print("showing all in ui_data->box_profile\n");
    
    //gtk_widget_hide_all(GTK_WIDGET(ui_data->box_profile));
    //callback_button_profile_save_detail(ui_data->box_profile);
    //gtk_widget_show_all(GTK_WIDGET(ui_data->box_profile));
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_profile_save_detail(GtkWidget* container)
{
    GList* children = gtk_container_get_children (container);
    for (; children != NULL; children = children->next){
        gtk_widget_realize(children->data);
        gtk_widget_show_now(children->data);
        gtk_widget_show_all(children->data);
        GList* subchildren;
        if (GTK_IS_CONTAINER(children->data)) {
            subchildren = gtk_container_get_children (GTK_CONTAINER(children->data));
            if(subchildren != NULL)
                callback_button_profile_save_detail(children->data);
        } else {
            gchar* label = gtk_widget_get_name(GTK_WIDGET(children->data));
            gchar* value;
            if (GTK_IS_LABEL(children->data))
                value = gtk_label_get_text(GTK_WIDGET(children->data));
            g_print("%s:\t%s\n", label, value);
        }
    }
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_setup_service(GtkWidget* button, int id_service)
{
    //int id_service = (*(int*)id);
    
    ui_data->srvc = id_service;
    callback_goto(NULL, 1);
    
    GList* node;
    int i = 0;
    msa_driver_info* info;
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        if (i == id_service){
            info = (msa_driver_info*)node->data;
                        
            g_debug("callback_get_settings: driver status = %d state = %d", info->status, info->state);

            kernel->send(xmlParseDoc(g_strconcat("<?xml version=\"1.0\"?><TransitData id=\"1\" \
    type=\"data\"><SourceID>ui</SourceID>\
    <TargetID>",info->id,"</TargetID>\
    <Content><Request class=\"settings\" function = \"getSettings\"><Params></Params></Request></Content></TransitData>",NULL)), NULL, NULL);
            break;
        }
        i++;
    }
    
    //gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->notebook), 1);
    g_print("setting up service #%d\n", id_service);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_cancel_edit(GtkWidget* button, gpointer data)
{
    //int id_service = (*(int*)id);
    //ui_data->page = 0;
    //ui_data->page = ui_data->prev;
    
    callback_goto(NULL, ui_data->prev);
    //gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->notebook), 1);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_cancel_setup_service(GtkWidget* button, int id_service)
{
    //int id_service = (*(int*)id);
    //ui_data->page = ui_data->prev;
    g_print("going to: %d\n", ui_data->prev);
    callback_goto(NULL, ui_data->prev);
    //gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->notebook), 1);
    g_print("setting up service #%d cancelled\n", id_service);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_button_save_setup_service(GtkWidget* button, gpointer id)
{
    //ui_data->page = 0;
    callback_goto(NULL, ui_data->prev);
    
    GList* children = gtk_container_get_children (ui_data->box_profile);
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    ui_data->empty_profile = TRUE;
    
    children = gtk_container_get_children (ui_data->box_friends_list);
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    ui_data->empty_friends = TRUE;
    
    children = gtk_container_get_children (ui_data->box_messages_list);
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    ui_data->empty_messages = TRUE;
    
    GList* node;
    int i = 0;
    msa_driver_info* info;
    
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        if (i == ui_data->srvc){
            info = (msa_driver_info*)node->data;
            char* actv;
            if (gtk_toggle_button_get_active(ui_data->entry_actv)){
                actv = g_strdup("1");
            } else {
                actv = g_strdup("0");
            }

            info->status = ON;
            info->state = CONF;    

            g_debug("SET_SETTINGS START %d %d", info->status, info->state);      
           
            g_debug("callback_get_settings: driver status = %d state = %d", info->status, info->state);
            kernel->msa_settings(info->id, xmlParseDoc(g_strconcat("<?xml version=\"1.0\"?><TransitData><SourceID>ui</SourceID><TargetID>",info->id,"</TargetID><Content><Request class=\"settings\" function=\"setSettings\"><Params><string name=\"login\">",gtk_entry_get_text(GTK_LABEL(ui_data->entry_logn)),"</string><string name=\"password\">",gtk_entry_get_text(GTK_LABEL(ui_data->entry_pass)),"</string><number name=\"autoupdate\">",gtk_entry_get_text(GTK_LABEL(ui_data->entry_auto)),"</number><boolean name=\"active\">",actv,"</boolean></Params></Request></Content></TransitData>",NULL)));
            break;
        }
        i++;
    }    
    
    //ui_init_page0(NULL);
    //callback_goto(NULL, NULL);
    //gtk_notebook_set_current_page(GTK_NOTEBOOK(ui_data->notebook), 1);
    g_print("service #%d settings saved\n", ui_data->srvc);
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
callback_label_profile_edit(GtkWidget* label, int number)
{
    g_print("%s\n",gtk_label_get_text(GTK_LABEL(label)));
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_empty(GtkWidget* widget, GdkEventButton* event, gpointer data)
{
    Message* msg = data;
    hildon_banner_show_information( NULL, NULL, (gchar*)msg->str_text ); 
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_task_switch(GtkWidget* notebook, GtkNotebookPage* page, guint page_num, gpointer user_data)
{
    //tkWidget* label = value;
    //gchar str = gtk_label_get_text(GTK_LABEL(label));
    
    //g_print("%s\n", &value);
    int n = gtk_notebook_get_current_page(notebook);
    g_print("callback task: %d\n", page_num);
    ui_data->str_page[2] = ui_data->str_task[page_num];
    if (gtk_notebook_get_current_page(GTK_NOTEBOOK(ui_data->notebook)) == 2) {
        gtk_window_set_title (GTK_WINDOW (ui_data->window), ui_data->str_page[2]);
        //FIXME
        if (page_num == 1) {
            callback_button_friends_get(NULL, NULL);
        } else if (page_num == 2) {
            callback_button_messages_get(NULL, NULL);
        }
    }
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_check_service(GtkWidget* widget, gpointer data)
{
    g_print("checked\n");
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
void callback_exit(GtkAction* action, gpointer data)
{
    kernel->shutdown();
    gtk_main_quit();
}

