/*
 * ui.c - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */ 
#define UI_NAME "msa_example"
#include "ui.h"

/** message **/
const char* img_resp = "\
<TransitData>\
<TargetID>db</TargetID>\
<SourceID>ui</SourceID>\
<Content>\
<Request class=\"binaryData\" function=\"getBinaryData\">\
<Params>\
</Params>\
</Request>\
</Content>\
</TransitData>";

/**
 * @brief initialization
 * @param module - user interface module info
 * @return 0
**/
extern int msa_module_init(msa_module *module)
{
    g_print("driver %s: init!", UI_NAME);   
    module->name = g_strndup(UI_NAME, 9);
    module->send = ui_got_response;
    module->module_start = ui_start;
    module->status = 1;
    module->state = 1;
    return 0;
}

/**
 * @brief
 * @param
 * @return
**/
static void ui_start(gpointer _data, gpointer list_drv, int argc, char* argv[])
{
    g_print("UI START ()");

    /* DRIVERS */
    kernel = (msa_module*)_data;
    GList* list = (GList*)list_drv;
    GList* node;
    msa_driver_info* info;
 
    /* GTK INIT */
    gtk_init(NULL, NULL);
    g_set_application_name(STR_PROG);
    
    /* CREATE UI DATA */
    ui_data = g_new0(UIdata, 1);
    ui_data->drivers = list_drv;
    ui_data->num_srvs =  g_list_length(list);
    ui_data->table_imgs = g_hash_table_new(g_str_hash, g_str_equal); 
    
    /* CREATE UI FORMS */
    ui_init();
}

/**
 * @brief
 * @param
 * @return
**/
int ui_got_response(xmlDocPtr _response, xmlDocPtr* doc, msa_driver_info* ui_info_not_use)
{
        gchar* class_name;
        gchar* func;
        GSource* source = g_timeout_source_new(TIMEOUT);
        xmlDocPtr response = xmlCopyDoc(_response,1);
        //xmlFreeDoc(ui_data->response);
        
        if (get_function_from_response(_response, &class_name, &func) == 0 ) {
            g_print("UI GOT RESPONSE: %s -> %s", class_name, func);
            if (strcmp(class_name, SETTINGS) == 0) {
                /* SETTINGS */
                if (strcmp(func, GET_SETTINGS) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_settings), (gpointer)response, NULL);
                }  
            } else if (strcmp(class_name, PROFILE) == 0) {
                /* PROFILE */
                if (strcmp(func, GET_PROFILE) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_profile), (gpointer)response, NULL);
                } else if (strcmp(func, GET_FRIENDS_PROFILE) == 0) {    
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_friends_profile), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, FRIENDS) == 0) {
                /* FRIENDS */
                if (strcmp(func, GET_FRIENDSLIST) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_friends), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, MESSAGES) == 0) {
                /* MESSAGES */
                if (strcmp(func, GET_INBOX) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_messages), (gpointer)response, NULL);
                }
                if (strcmp(func, GET_OUTBOX) == 0) {    
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_messages), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, SYSTEM_MESSAGES) == 0) {
                /* SYSTEM MESSAGES */
                if (strcmp(func, ERROR_MESSAGE) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_show_error), (gpointer)response, NULL);
                } 
                if (strcmp(func, INFO_MESSAGE) == 0) {        
                    g_source_set_callback(source, G_CALLBACK(ui_show_info), (gpointer)response, NULL);
                }
                if (strcmp(func, CAPTCHA_MSG) == 0) {        
                    g_source_set_callback(source, G_CALLBACK(ui_show_captcha), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, CLASS_BINARY_DATA) == 0) {
                /* BINARY DATA */
                if (strcmp(func, GET_BINARY_DATA) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_show_img), (gpointer)response, NULL);    
                } 
            }
        }
       g_source_attach(source, NULL);
       ui_data->source_time = source;
       return 0;
}

/**
 * @brief
 * @param
 * @return
**/
int ui_driver_get_profile(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    ui_data->ui_request = xmlCopyDoc(request,1);
    xmlNodePtr cont;
    gchar* date_birth;

    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    
    xmlNodePtr node2, node, next_node, prev_node;
    xmlDocPtr response, doc_resp;
    xmlChar* resp;
    //xmlDocDump(stdout,request);

    response = xmlNewDoc(BAD_CAST "1.0");
    response->encoding="utf-8";

    node = xmlNewNode(NULL,"TransitData");
    xmlDocSetRootElement(response,node);

    xmlNodePtr child;
    child = xmlNewNode(NULL,"SourceID");
    xmlNodeSetContent(child,"ui");
    xmlAddChild(node,child);

    child = xmlNewNode(NULL,"TargetID");
    xmlNodeSetContent(child,"vkontakte");
    xmlAddChild(node,child);

    child = xmlNewNode(NULL,"Content");
    xmlAddChild(node,child);

    node = xmlNewNode(NULL,"Request");
    xmlAddChild(child,node);
    xmlSetProp(node,"class", "profile");
    xmlSetProp(node,"function", "sendMyProfile");

    child=xmlNewNode(NULL,"Params");
    xmlAddChild(node,child);
    
    node = xmlDocGetRootElement(request);
    
    g_debug("%s", node->name);
    
    node = node->children;

    while(node != NULL)
    {
        if(strcmp(node->name, "Content") == 0)
        {
                    break;
        }
        node = node->next;
    }    
   
    node = node->children; // Request
    cont = node->children; // Params
    node = cont->children; // Req_params

    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_profile));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_left = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_main = gtk_hbox_new(FALSE, 0);
    GtkWidget* vbox_right = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_details = gtk_hbox_new(FALSE, 0);
    gtk_widget_set_name(vbox_right, STR_PRFL);
    gtk_box_pack_start (GTK_BOX (hbox_details), vbox_left, TRUE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (hbox_details), vbox_right, FALSE, FALSE, 0);
    
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    gtk_scrolled_window_add_with_viewport(scrollable, hbox_main);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_profile), scrollable, TRUE, TRUE, 0);

    int i = 0;
    g_print("creating list\n");
    GtkWidget* detail;
    GtkWidget* label;
    g_print("list created\n");
    
    while(node != NULL)
    {
        gchar* type = (gchar*)node->name;
        if (!strcmp(type, TYPE_STRNG)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = ui_init_detail(xmlGetProp(node, "name"),  (gchar*)xmlNodeGetContent(node));
            gtk_box_pack_start (GTK_BOX (vbox_left), label, FALSE, FALSE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), detail, FALSE, FALSE, 0); 
        } else if (!strcmp(type, TYPE_IMAGE)) {
            cont = node;
        } else if (!strcmp(type, TYPE_SELCT)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            GtkWidget* combo = gtk_combo_box_new_text();
            xmlNodePtr select = node->children;
            int i = 0;
            int n = 0;
            while (select != NULL) {
                gtk_combo_box_append_text(GTK_COMBO_BOX(combo), (gchar*)xmlNodeGetContent(select));
                if (!strcmp(xmlGetProp(select, "selected"), "1")) {
                    //combo = ui_init_label(xmlGetProp(select, "name"));
                    //gtk_label_set_text (detail, (gchar*)xmlNodeGetContent(select)) ;  
                    n = i;
                }
                select = select->next;                
                i++;
            }
            gtk_widget_set_name(combo, xmlGetProp(node, "name"));
            gtk_combo_box_set_active(GTK_COMBO_BOX(combo), n);
            g_signal_connect(G_OBJECT(combo), "changed", G_CALLBACK(callback_combo_changed), (gpointer)xmlGetProp(node, "name"));
            gtk_box_pack_start (GTK_BOX (vbox_left), label, TRUE, TRUE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), combo, FALSE, FALSE, PADDING);
        } else if (!strcmp(type, TYPE_DATE)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = ui_init_date_chooser(xmlGetProp(node, "name"),  (gchar*)xmlNodeGetContent(node));
            gtk_box_pack_start (GTK_BOX (vbox_left), label, TRUE, TRUE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), detail, TRUE, TRUE, 0); 
        } else {
            g_print ("%s\n", type);
            //gchar* str_label = ;
            //gchar* str_value = (gchar*)xmlNodeGetContent(node);

            //label = ui_init_label(str_label);
            //detail = ui_init_detail(str_label, str_value);

            //gtk_box_pack_start (GTK_BOX (vbox_left), label, TRUE, TRUE, 0);        
            //gtk_box_pack_start (GTK_BOX (vbox_right), detail, TRUE, TRUE, 0);
        }
        node = node->next;

    }
    
    guchar* buff; 
    guchar* undecoded;
    GdkPixbuf* pixbuff;  
    int size;    
    undecoded = g_strdup((gchar*)xmlNodeGetContent(cont));
    buff = g_base64_decode(undecoded, &size);    
    GdkPixbufLoader* pbloader;
    pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
    gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
    gdk_pixbuf_loader_close (pbloader, NULL);
    
    int height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader));
    if (height > MAX_HEIGHT_PHOTO) {
        int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MAX_HEIGHT_PHOTO / height;
        height = MAX_HEIGHT_PHOTO;
        pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
    } else {
        pixbuff = gdk_pixbuf_loader_get_pixbuf(pbloader);
    }        
    GtkWidget* image = gtk_image_new_from_pixbuf (pixbuff);
    g_object_unref(pbloader);
    g_free(buff);
    g_free(undecoded);
    gtk_widget_set_usize (image, MIN_WIDTH, -1);
    gtk_box_pack_start (GTK_BOX (hbox_main), hbox_details, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_main), image, TRUE, TRUE, 0);
    
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_profile));
    //g_print("profile form created\n");
    //int ret_val;
    //g_signal_emit_by_name(GTK_OBJECT(ui_data->window),"expose_event",GTK_TYPE_NONE,&ret_val);
    
    resp = g_strdup("<answer>ok!</answer>");
    //if(if_set==1){
    //set_profile(response);
    //}
    
    xmlFreeDoc(request);
   
    return 0;

}

/**
 * @brief
 * @param
 * @return
**/
static gpointer ui_init_label(gchar* str_label)
{
    GtkWidget* label = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(label),(g_strconcat(MARKUP,str_label,": ",PUKRAM,NULL)));
    
    GtkWidget* alignment_label = gtk_alignment_new(1, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(alignment_label), label);

    gtk_widget_show_all(alignment_label);
    //g_print("detail created\n");
    return alignment_label;
}

/**
 * @brief
 * @param
 * @return
**/
static gpointer ui_init_detail(gchar* str_label, gchar* str_value)
{
    //g_print("creating detail %s:%s\n", str_label, str_value);
    GtkWidget* container = gtk_event_box_new(); 
    GtkWidget* value = gtk_label_new(str_value);
    gtk_widget_set_name (GTK_WIDGET(value), str_label);
    GtkWidget* alignment_value = gtk_alignment_new(0, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_value), value);
    gtk_container_add(GTK_CONTAINER(container), alignment_value);    
    g_signal_connect(G_OBJECT(container), "button_press_event", G_CALLBACK(callback_detail_edit), (gpointer)str_value);
    gtk_widget_show_all(container);
    //g_print("detail created\n");
    return container;
}

/**
 * @brief create date chooser
 * @param reqXml - where to search
 * @param class_name - where to put class name 
 * @param class_name - where to put function name 
 * @return xmlNodePtr*  
**/
static gpointer ui_init_date_chooser(gchar* str_label, gchar* str_value)
{
    //g_print("creating detail %s:%s\n", str_label, str_value);
    GtkWidget* container = gtk_event_box_new(); 
    GtkWidget* value = gtk_label_new(str_value);
    gtk_widget_set_name (GTK_WIDGET(value), str_label);
    GtkWidget* alignment_value = gtk_alignment_new(0, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_value), value);
    gtk_container_add(GTK_CONTAINER(container), alignment_value);    
    g_signal_connect(G_OBJECT(container), "button_press_event", G_CALLBACK(callback_date_edit), (gpointer)str_value);
    gtk_widget_show_all(container);
    return container;
}



/**
 * @brief show list of friends
 * @param xmlDocPtr request - response from drivers
 */
int ui_driver_get_friends(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;

    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    
    //gchar* xpath_req = g_strconcat(REQUEST_PARAMS_TAG_XPATH, "/img", NULL);
    //hildon_banner_show_information( NULL, NULL, STR_FRDS);  
    
    xmlXPathObject *Obj;
    xmlNodePtr node_root;
    xmlNodePtr node;
    gchar* str_name;
    gchar* str_status;
    gchar* str_filter;
    xmlDocPtr img_req = xmlParseDoc(img_resp);

    Obj = xpath(REQUEST_PARAMS_TAG_XPATH, img_req);
    xmlNodePtr node_params = Obj->nodesetval->nodeTab[0];
    xmlNodePtr node_img;
    //gchar* str_img;
    gint i;
    
    Obj = xpath(PARAMS_TAG_XPATH, request);
  
    node = Obj->nodesetval->nodeTab[0];
    g_debug("xpath: %d, %s", Obj->nodesetval->nodeNr, node->name);         
    
    
    //g_hash_table_remove_all(ui_data->table_imgs);
    g_hash_table_foreach_remove(ui_data->table_imgs, remove_friends_img, NULL);

    /* stuct contacts */
    node_root = node->children;
    ui_data->num_frds = atoi(xmlGetProp(node,"friendsQuantity"));
    
    str_filter = xmlGetProp(node, "Filter");
    if (str_filter != NULL) {
        if (strlen(str_filter) > 0) {
            callback_friends_filter(str_filter);
        } else {
            callback_friends_filter(NULL);
        }
    } else {
        callback_friends_filter(NULL);
    }
    int from = ui_data->page_frds * FRIENDS_PER_PAGE;
    int to = (ui_data->page_frds + 1) * FRIENDS_PER_PAGE;
    gboolean send = FALSE;
    if (to >  ui_data->num_frds) {
        to =  ui_data->num_frds;
    }

    if (from == 0) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_prev), FALSE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_frst), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_prev), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_frst), TRUE);
    }

    if (to == ui_data->num_frds) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_next), FALSE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_last), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_next), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_last), TRUE);
    }

    gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), g_strdup_printf("%d - %d / %d", from + 1, to, ui_data->num_frds));
    gtk_widget_set_usize(GTK_WIDGET(ui_data->label_friends_page), -1, MIN_HEIGHT);
    
    /* REMOVE FRIENDS LIST */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_friends_list));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_friends = gtk_vbox_new(FALSE, PADDING);
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    gtk_scrolled_window_add_with_viewport(GTK_WINDOW(scrollable), vbox_friends);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    GtkWidget* friend;
    GtkWidget* separator;
    Friend* struct_friend;
    
    for (node = node_root; node != NULL; node = node->next) {
        struct_friend = g_new0(Friend, 1);
        struct_friend->str_id = xmlGetProp(node, "id");
        struct_friend->str_name = xmlNodeGetContent(node->children);
        struct_friend->str_status = xmlNodeGetContent(node->children->next);
        struct_friend->str_img = xmlNodeGetContent(node->children->next->next);
        struct_friend->str_uri = xmlGetProp(node->children->next->next, "uri");
        
        if(strlen(struct_friend->str_img) < 1 && strlen(struct_friend->str_uri) > 0) {
            node_img = xmlNewNode(NULL, "img");
            xmlSetProp(node_img, "uri", struct_friend->str_uri);
            xmlAddChild(node_params,node_img);
            send = TRUE; 
        }
        
        friend = ui_friend((gpointer)struct_friend);
        g_free(struct_friend->str_img);
        separator = gtk_hseparator_new();
        //gtk_widget_set_usize (separator, -1, MIN_HEIGHT);
        gtk_box_pack_start (GTK_BOX (vbox_friends), friend, TRUE, TRUE, 0);
        if (node->next != NULL) {
            gtk_box_pack_start (GTK_BOX (vbox_friends), separator, TRUE, TRUE, 0);
        }
    }
    if(send) {
        kernel->send(img_req, NULL, NULL);
    }
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_list), scrollable, TRUE, TRUE, 0); 
    gtk_widget_show_all(ui_data->box_friends_list);
    xmlFreeDoc(request);
    //xmlFreeDoc(img_req);
    //xmlFreeDoc((xmlDocPtr)ptr_request);
    return 0; 
}


gboolean remove_friends_img(gpointer key, gpointer value, gpointer user_data)
{
	//g_debug("remove_friends_img %s", (gchar*)key, (gchar*)value);
	gtk_widget_destroy(GTK_WIDGET(value));
	//g_debug("!!!!!!");
	return TRUE;
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
gpointer ui_friend(gpointer ptr_friend)
{
    Friend* friend = g_new0(Friend, 1);
    friend = ptr_friend;
    GSource* source;
    
    //g_print("creating detail %s:%s\n", str_label, str_value);
    GtkWidget* container = gtk_event_box_new();
    
    GtkWidget* label_name = gtk_label_new(NULL);
    if (!strcmp(friend->str_status, "1")) {
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP_ONLINE, friend->str_name, PUKRAM, NULL));
    } else {
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP_OFFLINE, friend->str_name, PUKRAM, NULL));
    }
    gtk_label_set_selectable(GTK_LABEL(label_name), TRUE);
    gtk_widget_set_name (GTK_WIDGET(label_name), friend->str_name);
    
    GtkWidget* hbox = gtk_hbox_new(FALSE, PADDING);
    GtkWidget* img_comp = gtk_image_new_from_file(IMG_COMP);
    GtkWidget* alignment_label = gtk_alignment_new(0, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label), label_name);
    
    GtkWidget* image;
    
    if (strlen(friend->str_img) > 0) { 
        int size;    
        guchar* buff = g_base64_decode(friend->str_img, &size);    
        GdkPixbufLoader* pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
        gdk_pixbuf_loader_close (pbloader, NULL);
        int width = MIN_WIDTH_PHOTO;
        int height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MIN_WIDTH_PHOTO / gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader));
        GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
        image = gtk_image_new_from_pixbuf(pixbuff);    
        g_object_unref(pbloader);
        g_free(buff);
        g_object_unref(pixbuff);
    } else {
        image = gtk_image_new_from_file(IMG_CONT);    
    }
    
    gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, PADDING);
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_profile));
    
    gtk_box_pack_start (GTK_BOX (hbox), alignment_label, TRUE, TRUE, 0);
    GtkWidget* button_msg = gtk_button_new();
    gtk_button_set_image(GTK_BUTTON(button_msg), GTK_IMAGE(img_comp));
    gtk_box_pack_start (GTK_BOX (hbox), button_msg, FALSE, FALSE, PADDING);
    gchar* ptr_str_id;
    ptr_str_id = g_strdup(friend->str_id);
    g_signal_connect(G_OBJECT(button_msg), "clicked", G_CALLBACK(callback_friend_send_message), (gpointer)ptr_str_id);
    
    gtk_container_add(GTK_CONTAINER(container), hbox);
    g_signal_connect(G_OBJECT(container), "button_press_event", G_CALLBACK(callback_friend), (gpointer)ptr_str_id);
    gtk_widget_show_all(container);
    
    gpointer obj = (gpointer)image;
    gpointer key = (gpointer)friend->str_uri;
    g_hash_table_insert(ui_data->table_imgs, key, obj); 

    return container;
}

void ui_img_req(gpointer ptr_img_req)
{
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    kernel->send((xmlDocPtr)ptr_img_req, NULL, NULL);
}

/**
 * @brief
 * @param
 * @return
**/
int ui_driver_get_friends_profile(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    ui_data->ui_request = xmlCopyDoc(request,1);
    xmlNodePtr node;
    xmlNodePtr cont;
    gchar* date_birth;

    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
   
    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params", request);
  
    node = obj->nodesetval->nodeTab[0]; 
    node = node->children;

    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_friends_profile));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_left = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_main = gtk_hbox_new(FALSE, 0);
    GtkWidget* vbox_right = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_details = gtk_hbox_new(FALSE, 0);
    gtk_widget_set_name(vbox_right, STR_PRFL);
    gtk_box_pack_start (GTK_BOX (hbox_details), vbox_left, TRUE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (hbox_details), vbox_right, FALSE, FALSE, 0);
    
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    gtk_scrolled_window_add_with_viewport(scrollable, hbox_main);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_friends_profile), scrollable, TRUE, TRUE, 0);

    int i = 0;
    g_print("creating list\n");
    GtkWidget* detail;
    GtkWidget* label;
    g_print("list created\n");
    
    while(node != NULL)
    {
        gchar* type = (gchar*)node->name;
        if (!strcmp(type, TYPE_STRNG)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = gtk_label_new((gchar*)xmlNodeGetContent(node));
            GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
            gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
            gtk_box_pack_start (GTK_BOX (vbox_left), label, FALSE, FALSE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, 0); 
        } else if (!strcmp(type, TYPE_DATE) && strcmp((gchar*)xmlNodeGetContent(node), "00.00.0")) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = gtk_label_new((gchar*)xmlNodeGetContent(node));
            GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
            gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
            gtk_box_pack_start (GTK_BOX (vbox_left), label, FALSE, FALSE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, 0);
        } else if (!strcmp(type, TYPE_IMAGE)) {
            cont = node;
        } else if (!strcmp(type, TYPE_SELCT)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            gtk_box_pack_start (GTK_BOX (vbox_left), label, TRUE, TRUE, 0);  
            xmlNodePtr select = node->children;
            int i = 0;
            int n = 0;
            while (select != NULL) {
                if (!strcmp(xmlGetProp(select, "selected"), "1")) {
                    detail = gtk_label_new((gchar*)xmlNodeGetContent(select));
                    GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
                    gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
                    gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, PADDING);
                }
                select = select->next;                
                i++;
            }            
        }
        node = node->next;
    }
    
    guchar* buff; 
    GdkPixbuf* pixbuff;  
    int size;    
    buff = g_base64_decode((gchar*)xmlNodeGetContent(cont), &size);    
    GdkPixbufLoader* pbloader;
    pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
    gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
    gdk_pixbuf_loader_close (pbloader, NULL);
    
    int height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader));
    if (height > MAX_HEIGHT_PHOTO) {
        int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MAX_HEIGHT_PHOTO / height;
        height = MAX_HEIGHT_PHOTO;
        pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
    } else {
        pixbuff = gdk_pixbuf_loader_get_pixbuf(pbloader);
    }        
    GtkWidget* image = gtk_image_new_from_pixbuf (pixbuff);
    g_object_unref(pbloader);
    g_free(buff);

    gtk_widget_set_usize (image, MIN_WIDTH, -1);
    gtk_box_pack_start (GTK_BOX (hbox_main), hbox_details, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_main), image, TRUE, TRUE, 0);  
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_friends_profile));
    //resp = g_strdup("<answer>ok!</answer>");
    xmlFreeDoc(request);
    return 0;
}

/**
 * @brief show list of messages
 * @param xmlDocPtr request - response from drivers
 */
int ui_driver_get_messages(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time); 
    xmlXPathObject *Obj;
    xmlNodePtr node_root;
    xmlNodePtr node, child;
    gint i;
    gint from;
    gint to;
    Message* msg;
    
    Obj = xpath(RESPONSE_PARAMS_TAG_XPATH, request);
    node = Obj->nodesetval->nodeTab[0];
    ui_data->num_msgs = atoi(xmlGetProp(node, "messagesQuantity"));
    from = atoi(xmlGetProp(node, "From"));
    to = atoi(xmlGetProp(node, "To"));
    if (to > ui_data->num_msgs) {
		to = ui_data->num_msgs;
    }

    if (from == 0) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_prev), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_prev), TRUE);
    }

    if (to == ui_data->num_msgs) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_next), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_next), TRUE);
    }
    
    //g_debug("%d %d %d", ui_data->num_msgs, from, to);
    //xmlDocDump(stdout, request);
    
    
    Obj = xpath(PARAMS_TAG_XPATH, request);
  
    node = Obj->nodesetval->nodeTab[0];
    /* stuct contacts */
    node_root = node->children;
    
    /* REMOVE MESSAGES LIST */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_messages_list));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_messages = gtk_vbox_new(FALSE, PADDING);
    GtkWidget* scrollable = gtk_scrolled_window_new(NULL, NULL); 
    gtk_scrolled_window_add_with_viewport(GTK_WINDOW(scrollable), vbox_messages);
    gtk_scrolled_window_set_policy(scrollable, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    
    GtkWidget* message;
    GtkWidget* separator;
    gchar* xpath_req;

    
    
    for (node = node_root; node != NULL; node = node->next) {
        msg = g_new0(Message, 1);
        //xpath_req = g_strconcat(PARAMS_TAG_XPATH, "/struct[@='",xmlGetProp(node, "id"),"']",NULL);    
        //Obj = xpath(xpath_req, request);
        //child = Obj->nodesetval->nodeTab[0];
        for (child = node->children; child != NULL; child = child->next) {
            if (!strcmp(xmlGetProp(child, "name"), "SenderId"))
                msg->str_sender_id = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "SenderName"))
                msg->str_sender_name = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "RecipientId"))
                msg->str_recipient_id = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "RecipientName"))
                msg->str_recipient_name = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "Time"))
                msg->str_time = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "Text")) {
                msg->str_text = xmlNodeGetContent(child);
                msg->str_text = g_strcompress (msg->str_text);
                msg->str_text = g_markup_escape_text(msg->str_text, strlen(msg->str_text));
            }
            if (!strcmp(xmlGetProp(child, "name"), "Status"))
                msg->str_status = xmlNodeGetContent(child);
        }
        message = ui_message((gpointer)msg);
        separator = gtk_hseparator_new();
        //gtk_widget_set_usize (separator, -1, MIN_HEIGHT);
        gtk_box_pack_start (GTK_BOX (vbox_messages), message, TRUE, TRUE, 0);
        if (node->next != NULL) {
            gtk_box_pack_start (GTK_BOX (vbox_messages), separator, TRUE, TRUE, 0);
        }
    }
    
    if (to > ui_data->num_msgs) {
        to = ui_data->num_msgs;
    }
    gtk_label_set_text(GTK_LABEL(ui_data->label_messages_page), g_strdup_printf("%d - %d", from + 1, to));
    
    
    gtk_box_pack_start (GTK_BOX (ui_data->box_messages_list), scrollable, TRUE, TRUE, 0); 
    gtk_widget_show_all(ui_data->box_messages_list);
    
    xmlFreeDoc(request);
    
    return 0; 
}

/**
 * @brief message
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
gpointer ui_message(gpointer msg_pointer)
{
    Message* msg = (Message*)msg_pointer;
    //g_print("creating detail %s:%s\n", str_label, str_value);
    GtkWidget* container = gtk_event_box_new();
    mbox type;
    GtkWidget* label_name = gtk_label_new(NULL);
    if (strlen(msg->str_sender_name) > 0) {
        type = INBOX;
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP, " from: ",PUKRAM, msg->str_sender_name, NULL));
    } else  if (strlen(msg->str_recipient_name) > 0) {
        type = SENT;
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP, " to: ",PUKRAM, msg->str_recipient_name, NULL));
    }
    GtkWidget* label_time = gtk_label_new(NULL);
    
    gchar* str_date = malloc(sizeof(gchar)*10);
    gchar* str_time = malloc(sizeof(gchar)*6);
    long int time = atoi(msg->str_time);
	time += 60 * 60 * 4;
    struct tm* tm_time = gmtime(&time);
    strftime(str_date, 11, "%d.%m.%Y\0", tm_time);
    strftime(str_time, 7, "%H:%M \0", tm_time);
    msg->str_date = str_date;
    msg->str_time = str_time;
    
    //gtk_label_set_angle(GTK_LABEL(label_time), 10);
    gtk_label_set_markup(GTK_LABEL(label_time), g_strconcat(MARKUP, " ", str_date, "  ", str_time, PUKRAM, NULL));
    GtkWidget* label_text = gtk_label_new(NULL);
    
    g_print("\n\t%s\n", msg->str_text);
    
    if (!strcmp(msg->str_status, "0")){
        gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP_UNREAD, msg->str_text, PUKRAM, NULL));
    } else {
        gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP_READ, msg->str_text, PUKRAM, NULL));   
    }
    //gtk_widget_set_usize(GTK_WIDGET(label_text), MIN_MSG_WIDTH, -1);
    gtk_label_set_line_wrap(GTK_LABEL(label_text), TRUE);
    gtk_label_set_single_line_mode(GTK_LABEL(label_text), FALSE);
    gtk_label_set_ellipsize(GTK_LABEL(label_text), PANGO_ELLIPSIZE_END);
    //gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP, " text: ",PUKRAM, str_text, NULL));
    
    GtkWidget* alignment_label_name = gtk_alignment_new(0, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label_name), label_name);
    
    GtkWidget* alignment_label_time = gtk_alignment_new(1, 0.5, 0, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label_time), label_time);
    
    GtkWidget* alignment_label_text = gtk_alignment_new(0, 0, 1, 0); 
    gtk_container_add(GTK_CONTAINER(alignment_label_text), label_text);
    gtk_misc_set_alignment(GTK_MISC(alignment_label_text), 0, 0.5);
    gtk_misc_set_alignment(GTK_MISC(label_text), 0, 0.5);
    gtk_misc_set_padding (GTK_MISC(label_text), PADDING, PADDING);
    
    //GtkWidget* alignment_label_text = gtk_layout_new(NULL, NULL);
    //gtk_widget_set_usize(GTK_WIDGET(alignment_label_text), MIN_MSG_WIDTH, MIN_HEIGHT);
    //gtk_layout_put (GTK_LAYOUT(alignment_label_text), label_text, 0, 0);
    
    //gtk_widget_set_name (GTK_WIDGET(label_name), str_name);
    
    GtkWidget* hbox = gtk_hbox_new(TRUE, 0);
    GtkWidget* vbox = gtk_vbox_new(FALSE, 0);
    
    
    //GtkWidget* alignment_label = gtk_alignment_new(0, 0.5, 0, 0); 
    //gtk_container_add(GTK_CONTAINER(alignment_label), label_name);
    
    //guchar* buff;    
    //cont = cont->next; // Binary Data    
    //int size;    
    //buff = g_base64_decode(str_img, &size);    
    //GdkPixbufLoader* pbloader;
    //pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
    //gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
    //gdk_pixbuf_loader_close (pbloader, NULL);
    //int width = gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
    //int height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) / 2;
    //GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);

    //GtkWidget* image = gtk_image_new_from_pixbuf (pixbuff);
    //gtk_widget_set_usize (image, MIN_WIDTH, -1);
    //gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, TRUE, 0);
    
    gtk_box_pack_start(GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX (hbox), alignment_label_name, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX (hbox), alignment_label_time, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX (vbox), alignment_label_text, TRUE, TRUE, 0);
    gtk_misc_set_padding (GTK_MISC(hbox), PADDING, PADDING);
    
    //GtkWidget* button_msg = gtk_button_new_with_label(STR_CMPS);
    //gtk_box_pack_start (GTK_BOX (hbox), button_msg, FALSE, FALSE, 0);
    
    gtk_container_add(GTK_CONTAINER(container), vbox);
    if (type == INBOX) {
        g_signal_connect(G_OBJECT(container), "button_press_event", G_CALLBACK(callback_message_reply), (gpointer)msg);
    } else {
        g_signal_connect(G_OBJECT(container), "button_press_event", G_CALLBACK(callback_empty), msg_pointer);
    }
    gtk_widget_show_all(container);
    return container;
}


/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
xmlXPathObject* xpath(char* req, xmlDocPtr doc)
{
    xmlXPathObject *Obj;
    xmlXPathContextPtr Ctx;
    
    g_debug("ui_xpath: %s", req);

    Ctx = xmlXPathNewContext(doc);
    
    if (Ctx == NULL) {
        g_debug("ui_xpath: error wrong request format!");
        return NULL;    
    }

    Obj = xmlXPathEvalExpression(req, Ctx);

    g_debug("ui_xpath: end");

    xmlFree(Ctx);

    return Obj;

}

/**
 * @brief search name_node in node 
 * @param node - where to search
 * @param name_node - what to search  
 * @return xmlNodePtr*  
**/
xmlNodePtr node_search(xmlNodePtr node, char* name_node)
{
    //g_debug("i'm in %s %s", node->name, name_node);
    
    node = node->children;
    
    while(node != NULL){
        if(strcmp(node->name, name_node) == 0){
                    break;
        }
    //g_debug("%s %s", node->name, name_node);
        node = node->next;
    }
    return node;
}

/**
 * @brief get class name and function name from response
 * @param reqXml - where to search
 * @param class_name - where to put class name 
 * @param class_name - where to put function name 
 * @return 1 if error occurred, 0 if no errors occurred
**/
int get_function_from_response(xmlDocPtr reqXml, char** class_name, char** func)
{
    g_debug("get_function_from_response: START");

    xmlNodePtr rootNode;

    //g_debug("get_req_class: START");

    rootNode = xmlDocGetRootElement(reqXml);
    
    //g_debug("get_req_class: %s", rootNode->name);        
    rootNode = node_search(rootNode, "Content");
    
    // Request
    //g_debug("get_req_class: %s", rootNode->name);
    
    if(node_search(rootNode, "Response") != NULL) {
        rootNode = node_search(rootNode, "Response");
    } else {
        rootNode = node_search(rootNode, "Request");
        if (rootNode == NULL) {
            //g_debug("get_req_class: END no func and class");
            return 1;
        }
    }
    //g_debug("get_req_class: %s", rootNode->name);

    //xmlDocDump(stdout, reqXml);
    *class_name = xmlGetProp(rootNode,"class");
    *func = xmlGetProp(rootNode,"function");
    
    
    g_debug("get_function_from_response: START");
    g_debug("get_req_class: END class = %s, func = %s", *class_name, *func);
    
    xmlFreeDoc(reqXml);
    return 0;
}

/**
 * @brief get driver settings
 * @param reqXml - response from driver
**/
void ui_driver_get_settings(gpointer ptr_reqXml)
{
    xmlDocPtr reqXml = (xmlDocPtr)ptr_reqXml;
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    xmlNodePtr rootNode;
    xmlNodePtr node;
    char* driver_id;
    GtkWidget* entries[4];
    int i = 0;
    
    g_print("\tui_driver_get_settings: START");
    
    rootNode = xmlDocGetRootElement(reqXml);
    //g_debug("ui_driver_get_settings: START");
    
    // Получаем имя источника
    node = node_search(rootNode, "SourceID");
    driver_id = xmlNodeGetContent(node);
 
    //g_debug("ui_dirver_get_settings: %s", driver_id);
    
    rootNode = node_search(rootNode, "Content");
    
    // Resopnse
    rootNode = node_search(rootNode, "Response");
    rootNode = rootNode->children;
    //g_debug(" ui_driver_get_settings: %s", rootNode->name);
    
    for(node = rootNode->children; node != NULL; node = node->next) {
        //g_usleep(5);
        char* string;
        string = g_strdup(xmlGetProp(node, "name"));
        //sprintf(string, xmlGetProp(node, "name"));
        if (!strcmp(string, "login")){
            gtk_entry_set_text(GTK_ENTRY(ui_data->entry_logn), g_strdup(xmlNodeGetContent(node)));
            g_print("\tlogin: %s\n", g_strdup(xmlNodeGetContent(node)));
        } else if (!strcmp(string, "password")){
            gtk_entry_set_text(GTK_ENTRY(ui_data->entry_pass), g_strdup(xmlNodeGetContent(node)));
        } else if (!strcmp(string, "autoupdate")){
            gtk_entry_set_text(GTK_ENTRY(ui_data->entry_auto), g_strdup(xmlNodeGetContent(node)));
        } else if (!strcmp(string, "active")){
            if(!strcmp(g_strdup(xmlNodeGetContent(node)),"0")){
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ui_data->entry_actv), FALSE);
            } else {
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ui_data->entry_actv), TRUE);
            }            
        }
        //g_print("name: %s\n", string);
        //GtkWidget* label0 = gtk_label_new(string);
        string = g_strdup(xmlNodeGetContent(node));
        
        //entries[i] = gtk_entry_new();        
        //GtkWidget* hbox = gtk_hbox_new(TRUE, 0);
        //gtk_box_pack_start (GTK_BOX (hbox), label0, TRUE, TRUE, 0);
        //gtk_box_pack_start (GTK_BOX (hbox), entries[i], TRUE, TRUE, 0);
        //gtk_box_pack_start (GTK_BOX (ui_data->box_setting), hbox, TRUE, TRUE, 0);
        //i++;
    }
    gtk_widget_show_all(ui_data->box_setting);
    //g_debug("ui_driver_get_settings: END");
    xmlFreeDoc(ui_data->response); 
}

/**
 * @brief show info from xml
 * @param
 * @return
**/
int ui_show_info(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    gchar* text;
    gchar* code;
    gchar* id_friend;
    gboolean show = TRUE;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);
     
    if (obj->nodesetval->nodeNr != 0) {
        text = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
        id_friend = text;
    }
    
    g_debug("send request :getProfile:");
    obj = xpath("//TransitData/Content/Response/Params/string[@name='code']", request);
     
    if (obj->nodesetval->nodeNr != 0) {
        code = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    
    if (strcmp(code, DB_SAVE_MESSAGE_PROFILE_CODE) == 0) {
        g_debug("!!!!!");
        //ui_data->source_time = g_timeout_source_new(TIMEOUT);
        //g_source_set_callback(ui_data->source_time, G_CALLBACK(callback_button_profile_get), NULL, NULL);
        callback_button_profile_get(NULL, NULL);
    }
    
    if (strcmp(code, DB_SAVE_MESSAGE_FRIENDS_CODE) == 0) {
        callback_button_friends_get(NULL, NULL);   
    }

    if (strcmp(code, DB_UPDATE_MESSAGE_INBOX_MESSAGES_CODE) == 0) {
        callback_button_messages_get(NULL, NULL);   
    }
    
    if (strcmp(code, DB_UPDATE_MESSAGE_OUTBOX_MESSAGES_CODE) == 0) {
        callback_button_messages_get(NULL, NULL);   
    }
    
    if (strcmp(code, DRV_SETT_SAVED_CODE) == 0) {
        callback_button_profile_update(NULL, NULL);   
    }


    if (strcmp(code, DB_SAVE_MESSAGE_FRIENDS_PROFILE_CODE) == 0) {
        show = FALSE;
        callback_button_friend_get(NULL, (gpointer)id_friend);
    }
    
    if (show) {
        hildon_banner_show_information(NULL, NULL, text);
    } else {
        hildon_banner_show_information(NULL, NULL, id_friend);
    }
    
    xmlFreeDoc(request);
    
    return 0;    
}

/**
 * @brief show error from xml
 * @param
 * @return
**/
int ui_show_error(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    
    gchar* text;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);
     
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        text = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    else {
        return 1;
    }
    
    hildon_banner_show_information(NULL, NULL, text);
    xmlFreeDoc(request);
    
}

/**
 * @brief show captcha
 * @param
 * @return
**/
int ui_show_captcha(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;
    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    xmlNodePtr node;
    gchar* str;
    gchar* str_img;
    gchar* buff;
    GdkPixbufLoader* pbloader;
    GdkPixbuf* pixbuff;
    GtkWidget* image;
    int size;
    int width;
    int height;
    gchar* str_entry;
    xmlDocPtr req_drv;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);     
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        str = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    else {
        return 1;
    }
    
    obj = xpath("//TransitData/Content/Response/Params/img", request);
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        str_img = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
        g_print("%s\n\n", str_img);
        buff = g_base64_decode(str_img, &size);    
        pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
        gdk_pixbuf_loader_close (pbloader, NULL);
        width = MIN_WIDTH;
        height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MIN_WIDTH / gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader));
        pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
        image = gtk_image_new_from_pixbuf(pixbuff); 
    }
    else {
        return 1;
    }
    
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new( FALSE, 0 ); 
    GtkWidget* label;
    GtkWidget* button;
    GtkWidget* entry;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), str);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);    
    button = gtk_button_new_with_label(STR_OK__);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT);

    entry = gtk_entry_new();
    gtk_widget_set_usize (entry, -1, MIN_HEIGHT);
    gtk_container_add(GTK_CONTAINER(dialog->vbox), image);
    gtk_container_add(GTK_CONTAINER(dialog->vbox), entry);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );
    result = gtk_dialog_run(dialog);
    if( result == GTK_RESPONSE_ACCEPT) {
        str_entry = gtk_entry_get_text(GTK_ENTRY(entry));
        
        req_drv = xmlCopyDoc(request, 1);
        /* change name node, class, function */
        obj = xpath("//TransitData/Content/Response", req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetName(node, "Request");
        }    
        /* change source id */
        obj = xpath(SOURCE_TAG_XPATH, req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetContent(node, "db");
        }    
        /** create target id **/
        obj = xpath(TARGET_TAG_XPATH, req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetContent(node, "vkontakte");
        }
        else {
            //FIXME
            node = xmlNewDocNode(req_drv, NULL, TARGET_NODE, "vkontakte");
            xmlNodePtr root = xmlDocGetRootElement(req_drv);
            xmlAddChild(root, node);    
        }
        obj = xpath("//TransitData/Content/Request/Params/string[@name='text']", req_drv);
        if (obj != NULL && obj->nodesetval->nodeNr != 0) {
            xmlNodeSetContent(obj->nodesetval->nodeTab[0],str_entry);
        }
        else {
            return 1;
        }
        //xmlDocDump(stdout,req_drv);
          kernel->send(req_drv, NULL, NULL);       
    }    
    gtk_widget_destroy(GTK_WIDGET(dialog));
    xmlFreeDoc(request);
    
}

/**
 * @brief show img from xml
 * @param
 * @return
**/
int ui_show_img(gpointer ptr_request)
{
    xmlDocPtr request = (xmlDocPtr)ptr_request;

    g_source_unref(ui_data->source_time);
    g_source_destroy(ui_data->source_time);
    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/img", request);
    xmlNodePtr node_bin;
    xmlNodePtr node;

    gchar* s_uri;
    gchar* s_img;  
    int size;    
    int height;
    int width = MIN_WIDTH_PHOTO;
    guchar* buff;
    
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        node = obj->nodesetval->nodeTab[0];
    }
    else {
        return 1;
    }

    for (node_bin = node; node_bin != NULL; node_bin = node_bin->next) {
    
           s_uri = xmlGetProp(node_bin, "uri");
           s_img = xmlNodeGetContent(node_bin);

        buff = g_base64_decode(s_img, &size);    
        GdkPixbufLoader* pbloader;
        pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
        gdk_pixbuf_loader_close (pbloader, NULL);
        width = MIN_WIDTH_PHOTO;
        height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MIN_WIDTH_PHOTO / gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader));
        GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
        
        gpointer value = g_hash_table_lookup(ui_data->table_imgs, (gpointer)s_uri);
        gtk_image_set_from_pixbuf ((GtkImage*)value, pixbuff);
        g_free(buff);
        g_object_unref(pbloader); 
    }
    
    xmlFreeDoc(request);
}
