/*
 * This file is a variation of he-fullscreen-button.h, which is part of the Hildon-Extras library
 */
#include <gtk/gtk.h>

#define	TYPE_IMGPARAM_WINDOW \
		(imgparam_window_get_type())

#define	IMGPARAM_WINDOW(object) \
		(G_TYPE_CHECK_INSTANCE_CAST((object), \
		TYPE_IMGPARAM_WINDOW, ImgparamWindow))

#define	IMGPARAM_WINDOW_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), \
		TYPE_IMGPARAM_WINDOW, ImgparamWindowClass))

#define	IS_IMGPARAM_WINDOW(object) \
		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
		TYPE_IMGPARAM_WINDOW))

#define	IS_IMGPARAM_WINDOW_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), \
		TYPE_IMGPARAM_WINDOW))

#define	IMGPARAM_WINDOW_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		TYPE_IMGPARAM_WINDOW, ImgparamWindowClass))

typedef struct	_ImgparamWindow ImgparamWindow;
typedef struct	_ImgparamWindowClass ImgparamWindowClass;

struct _ImgparamWindow
{
        GObject      parent;

        GtkWindow   *parent_window;
};

struct _ImgparamWindowClass
{
        GObjectClass parent_class;

        void (*clicked) (ImgparamWindow *manager);
};

GType
imgparam_window_get_type (void);

ImgparamWindow *
imgparam_window_new (GtkWindow *window, const gchar *markup);

void
imgparam_window_hide (ImgparamWindow *self);

void
imgparam_window_show (ImgparamWindow *self);

GtkWidget *
imgparam_window_get_overlay (ImgparamWindow *self);

GtkWindow *
imgparam_window_get_window (ImgparamWindow *self);
