/*
 * This file is a variation of he-fullscreen-button.h, which is part of the Hildon-Extras library
 */
#include <gtk/gtk.h>

#define	TYPE_ARROW_BUTTON \
		(arrow_button_get_type())

#define	ARROW_BUTTON(object) \
		(G_TYPE_CHECK_INSTANCE_CAST((object), \
		TYPE_ARROW_BUTTON, ArrowButton))

#define	ARROW_BUTTON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), \
		TYPE_ARROW_BUTTON, ArrowButtonClass))

#define	IS_ARROW_BUTTON(object) \
		(G_TYPE_CHECK_INSTANCE_TYPE((object), \
		TYPE_ARROW_BUTTON))

#define	IS_ARROW_BUTTON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), \
		TYPE_ARROW_BUTTON))

#define	ARROW_BUTTON_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		TYPE_ARROW_BUTTON, ArrowButtonClass))

typedef enum
{
	ARROW_LEFT,
	ARROW_RIGHT
} arrow_direction_t;

typedef struct	_ArrowButton ArrowButton;
typedef struct	_ArrowButtonClass ArrowButtonClass;

struct _ArrowButton
{
        GObject      parent;

        GtkWindow   *parent_window;
};

struct _ArrowButtonClass
{
        GObjectClass parent_class;

        void (*clicked) (ArrowButton *manager);
};

GType
arrow_button_get_type (void);

ArrowButton *
arrow_button_new (GtkWindow *window, arrow_direction_t arrow_direction);

void
arrow_button_disable (ArrowButton *self);

void
arrow_button_enable (ArrowButton *self);

gboolean
arrow_button_is_enabled (ArrowButton *self);

GtkWidget *
arrow_button_get_overlay (ArrowButton *self);

GtkWindow *
arrow_button_get_window (ArrowButton *self);
