/*******************************************************************************
 * Copyright (c) 2009 Luca Donaggio.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* Includes */
#include <gtk/gtkmain.h>
#include "hildon/hildon.h"
#include <libosso.h>
#include <string.h>
#include <stdlib.h>

#include "localisation.h"
#include "interface.h"
#include "../config.h"

int main(int argc,char* argv[]) {
    app_data_t myapp;
    osso_context_t *osso_cont;
    const gchar *myrawext[] = {"PEF","DNG","NEF","ARW","CR2","CRW","RAF","DCR","MRW","ORF","SRF","SR2","MOS",NULL};

    /* Initialize OSSO context */
    osso_cont = osso_initialize(PACKAGE, VERSION, TRUE, NULL);
	if (osso_cont == NULL) {
		fprintf(stderr, "osso_initialize failed.\n");
    	exit(1);
    }

    /* Initialize the GTK. */
    gtk_init(&argc, &argv);

	/* Create hildon program */
    myapp.imgbuffer = NULL;
    myapp.allimgindir = NULL;
    myapp.currdir = NULL;
    myapp.currfname = NULL;
    myapp.currfindex = 0;
    myapp.imgparam = NULL;
    myapp.showimgparam = FALSE;
    myapp.pressbuttontime = 0;
    myapp.rawext = myrawext;
    create_app(&myapp);

    /* Begin the main application */
    gtk_main();

    /* Exit */
    osso_deinitialize(osso_cont);
    return 0;
}
