#include "azanwindow.h"
#include "ui_azanwindow.h"
#include "dbusCommands.h"
#include "alarmHandler.h"
#include <QTime>
#include <QMediaPlayer>
AzanWindow::AzanWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::AzanWindow)
{
    ui->setupUi(this);
}

AzanWindow::~AzanWindow()
{
    delete ui;
}
void AzanWindow::setAzan(char* whichAzan){
    ui->lblAzan->setText(QString(whichAzan));
    ui->lblTime->setText(QTime::currentTime().toString("'Current Time:' hh:mm"));
    bool iqama=QString(whichAzan).contains(QString("ikama"));
    QMediaPlayer *player = new QMediaPlayer;
    DbusCommands *dbusCommands=new DbusCommands(this);
    if(iqama){
        player->setMedia(QUrl::fromLocalFile("/usr/share/sounds/mprayertime_iqama.mp3"));
        if(!dbusCommands->getCurrentProfile().contains("silent")){
            AlarmHandler::addProfileAlarm(QString(whichAzan));
        }
    }else{
        player->setMedia(QUrl::fromLocalFile("/usr/share/sounds/mprayertime_azan.mp3"));
    }
    player->setVolume(70);
    player->play();

// the commented lines makes the vibration run till the media stops
//    QObject::connect(player,SIGNAL(stateChanged(QMediaPlayer::State))
//                     ,v,SLOT(stopVibration()));
    QObject::connect(player,SIGNAL(stateChanged(QMediaPlayer::State))
                        ,this,SLOT(close()));
    dbusCommands->enableVibration();
    dbusCommands->vibrate();
}

