#include "prayertimesettings.h"
#include <QCoreApplication>

QSettings settings("Team Mohannad", "mPrayerTime");

PrayerTimeSettings::PrayerTimeSettings()
{

}

double PrayerTimeSettings::getLatitude(){
    return settings.value("latitude").toDouble();
}

double PrayerTimeSettings::getLongitude(){
    return settings.value("longitude").toDouble();
}

double PrayerTimeSettings::getTimeZone(){
    return settings.value("timeZone").toDouble();
}

int PrayerTimeSettings::getTimeFormat(){
    return settings.value("timeFormat").toInt();
}

int PrayerTimeSettings::getCalcMethod(){
    return settings.value("calcMethod").toInt();
}

int PrayerTimeSettings::getJuristicMethod(){
    return settings.value("jMethod").toInt();
}

int PrayerTimeSettings::getLatMethod(){
    return settings.value("latMethod").toInt();
}

void PrayerTimeSettings::update(QString lat, QString longitude, QString timeZone, int calcMethod, int jMethod, int latMethod, int timeFormat){
    settings.setValue("latitude", lat);
    settings.setValue("longitude", longitude);
    settings.setValue("timeZone", timeZone);
    settings.setValue("calcMethod", calcMethod);
    settings.setValue("jMethod", jMethod);
    settings.setValue("latMethod", latMethod);
    settings.setValue("timeFormat", timeFormat);
}

bool PrayerTimeSettings::setupCompleted(){

    double longitude = getLongitude();
    double latitude = getLatitude();
    if (longitude == 0.0 && latitude == 0.0){
        return false;
    }
    return true;

}


