#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include "optionsdialog.h"
#include "aboutdialog.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    bool setupCompleted();
    void setupTimes();
    void printTimes(QString times);

public slots:
    void showOptions();
    void showAbout();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    void createMenu();

private:
    QPointer<OptionsDialog> optionsDialog;
    QPointer<AboutDialog> aboutDialog;
    PrayerTimeSettings settings;

};




#endif // MAINWINDOW_H
