#include "optionsdialog.h"
#include "ui_optionsdialog.h"

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog)
{
    ui->setupUi(this);
    if (settings.setupCompleted()){
        QString s;
        this->ui->latLineEdit->setText(s.setNum(settings.getLatitude(),'f',6));
        this->ui->longLineEdit->setText(s.setNum(settings.getLongitude(),'f',6));
        this->ui->tzLineEdit->setText(s.setNum(settings.getTimeZone(),'f',2));
        this->ui->timeFormatBox->setCurrentIndex(settings.getTimeFormat());
        this->ui->calcMethoBox->setCurrentIndex(settings.getCalcMethod());
        this->ui->jMethodBox->setCurrentIndex(settings.getJuristicMethod());
        this->ui->latMethodBox->setCurrentIndex(settings.getLatMethod());
    }
}

void OptionsDialog::positionUpdated(const QGeoPositionInfo &info)
{
    float lng = info.coordinate().longitude();
    float lat = info.coordinate().latitude();
    QString s;
    this->ui->latLineEdit->setText(s.setNum(lat,'f',6));
    this->ui->longLineEdit->setText(s.setNum(lng,'f',6));
    QDateTime dt;
    QDateTime utc;
    dt = QDateTime::currentDateTime();
    utc = dt.toUTC();
    float timezone;
    int hourdiff = dt.time().hour() - utc.time().hour();
    int daydiff = dt.date().dayOfYear() - utc.date().dayOfYear();
    int yeardiff = dt.date().year() - dt.date().year();
    if (daydiff == 0 && yeardiff == 0){
        timezone = hourdiff;
    } else if (daydiff > 0 || yeardiff > 0){
        timezone = hourdiff + 24;
    } else {
        timezone = hourdiff - 24;
    }
    this->ui->tzLineEdit->setText(s.setNum(timezone,'f',2));
    qDebug("local: %i, utc: %i, diff: %f",dt.time().hour(), utc.time().hour(),timezone);
    qDebug("lat: %f, long: %f", lat, lng);
    source->stopUpdates();
}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void OptionsDialog::saveClickedHandler(){
    settings.update(ui->latLineEdit->text(), ui->longLineEdit->text(),ui->tzLineEdit->text(),ui->calcMethoBox->currentIndex(),
                    ui->jMethodBox->currentIndex(), ui->latMethodBox->currentIndex(),ui->timeFormatBox->currentIndex());
    this->accept();
}

void OptionsDialog::autoConfigureClickHandler(){
    source = QGeoPositionInfoSource::createDefaultSource(this);
    if (source) {
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)),
        this, SLOT(positionUpdated(QGeoPositionInfo)));
        source->startUpdates();
    }

}
void OptionsDialog::save(){


}

QString OptionsDialog::doubleToString(double in){
    QString s;
    s.setNum(in, 'g', 6);
    return s;
}

QString OptionsDialog::intToString(int in){
    QString s;
    s.setNum(in, 10);
    return s;
}
