#include "optionsdialog.h"
#include "ui_optionsdialog.h"

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::OptionsDialog)
{
    ui->setupUi(this);
    if (settings.setupCompleted()){
        QString s;
        this->ui->latLineEdit->setText(s.setNum(settings.getLatitude(),'f',6));
        this->ui->longLineEdit->setText(s.setNum(settings.getLongitude(),'f',6));
        this->ui->tzLineEdit->setText(s.setNum(settings.getTimeZone(),10));
        this->ui->timeFormatBox->setCurrentIndex(settings.getTimeFormat());
        this->ui->calcMethoBox->setCurrentIndex(settings.getCalcMethod());
        this->ui->jMethodBox->setCurrentIndex(settings.getJuristicMethod());
        this->ui->latMethodBox->setCurrentIndex(settings.getLatMethod());
    }


}

OptionsDialog::~OptionsDialog()
{
    delete ui;
}

void OptionsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void OptionsDialog::saveClickedHandler(){
    settings.update(ui->latLineEdit->text(), ui->longLineEdit->text(),ui->tzLineEdit->text(),ui->calcMethoBox->currentIndex(),
                    ui->jMethodBox->currentIndex(), ui->latMethodBox->currentIndex(),ui->timeFormatBox->currentIndex());
    this->accept();
}

void OptionsDialog::save(){


}

QString OptionsDialog::doubleToString(double in){
    QString s;
    s.setNum(in, 'g', 6);
    return s;
}

QString OptionsDialog::intToString(int in){
    QString s;
    s.setNum(in, 10);
    return s;
}
