// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "theatermodel.h"

#include "data/cinemaschedule.h"
#include "data/cinema.h"
#include "utils/assertedlocker.h"

#include <iostream>

TheaterModel::TheaterModel(const CinemaSchedule *cinema_schedule, QObject *parent)
    : QAbstractListModel(parent),
    _cinema_schedule(cinema_schedule)
{
}

int TheaterModel::rowCount(const QModelIndex &parent) const
{
    Q_UNUSED(parent);
    AssertedReadLocker locker(_cinema_schedule->GetLock());
    return _cinema_schedule->GetCinemas().values().size();
}

QVariant TheaterModel::data(const QModelIndex &index, int role) const
{
    AssertedReadLocker locker(_cinema_schedule->GetLock());
    if (!(index.isValid() && index.row() >= 0 && index.row() < _cinema_schedule->GetCinemas().values().size())) {
        std::cout << "TheaterModel: invalid index" << std::endl;
        return QVariant();
    }
    Cinema *cinema = _cinema_schedule->GetCinemas().values().operator [](index.row());
    if (cinema == 0) {
        std::cout << "cinema is 0 (row = " << index.row() << ", size = " << _cinema_schedule->GetCinemas().values().size() << ")" << std::endl;
        return QVariant();
    }
    //std::cout << "row = " << index.row() << " role = " << role << std::endl;
    switch (role) {
    case Qt::DisplayRole:
    case TheaterItemRole:
        return qVariantFromValue(TheaterItem(*cinema));
    case TheaterKeyRole:
        return qVariantFromValue(cinema->GetKey());
    case SortRole:
        return QVariant(cinema->GetName());
    }
    return QVariant();
}
