// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef STYLEUTILS_H
#define STYLEUTILS_H

#include <QColor>
#include <QTime>
#include <QDate>

class QPalette;

class StyleUtils
{
    friend class StyleUtilsSingleton;

public:
    enum StandardColor {
        DefaultBackgroundColor,
        DefaultTextColor,
        SecondaryTextColor
    };

    enum Font {
        TextFont,
        SecondaryTextFont,
    };

private:
    StyleUtils();

public:
    QColor GetColor(const QPalette &palette, StandardColor standard_color);

    QColor GetScheduleTimeColor(const QPalette &palette, QTime time);

    QColor GetDayTextColor(const QPalette &palette, const QDate &date);

    QColor GetDayBackgroundColor(const QPalette &palette, const QDate &date);

public:
    static StyleUtils *INSTANCE() { return _instance; }

private:
    static StyleUtils *_instance;
};

class StyleUtilsSingleton
{
public:
    StyleUtilsSingleton();

private:
    StyleUtils _instance;
};

#endif // STYLEUTILS_H
