// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "theaterwindow.h"
#include "ui_theaterwindow.h"

#include "theaterscheduledelegate.h"
#include "theaterschedulemodel.h"
#include "data/cinemaschedule.h"

#include <QStackedLayout>
#ifdef Q_WS_MAEMO_5
#include <QAbstractKineticScroller>
#endif

TheaterWindow::TheaterWindow(CinemaSchedule *cinema_schedule, QWidget *parent) :
    AbstractMainWindow(parent),
    ui(new Ui::TheaterWindow),
    _cinema_schedule(cinema_schedule),
    _theater_schedule_model(0)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    QStackedLayout *layout = dynamic_cast<QStackedLayout*>(ui->MainStack->layout());
    if (layout != 0) {
        layout->setStackingMode(QStackedLayout::StackAll);
    }
    QFont f(font());
    f.setPointSizeF(f.pointSizeF() * 1.5);
    ui->ErrorMessage->setFont(f);
    ui->Schedule->setItemDelegate(new TheaterScheduleDelegate(this));
    ui->Schedule->setProperty("FingerScrollable", true);
    connect(ui->Schedule, SIGNAL(clicked(QModelIndex)), this, SLOT(ScheduleEntrySelected(QModelIndex)));
}

TheaterWindow::~TheaterWindow()
{
    delete ui;
}

void TheaterWindow::SetTheaterName(QString movie_name)
{
    ui->Background->SetLabelText(movie_name);
}

void TheaterWindow::SetTheaterScheduleModel(QAbstractItemModel *theater_schedule_model)
{
    _theater_schedule_model = theater_schedule_model;
    ui->TheaterPages->setCurrentWidget(ui->TheaterPage);
    ui->Schedule->setModel(_theater_schedule_model);
}

void TheaterWindow::SetError(QString error_text)
{
    ui->TheaterPages->setCurrentWidget(ui->ErrorPage);
    ui->ErrorMessage->setText(error_text);
}

bool TheaterWindow::IsIdle()
{
#ifdef Q_WS_MAEMO_5
    QAbstractKineticScroller *k1 = ui->Schedule->property("kineticScroller").value<QAbstractKineticScroller *>();
    bool k1_idle = (k1 == 0) || (k1->state() == QAbstractKineticScroller::Inactive);
    return k1_idle;
#else
    return true;
#endif
}

void TheaterWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TheaterWindow::ScheduleEntrySelected(QModelIndex index)
{
    QVariant var = _theater_schedule_model->data(index, TheaterScheduleModel::TheaterScheduleKeyRole);
    ScheduleEntryKey schedule_entry_key = qVariantValue<ScheduleEntryKey>(var);
    emit ScheduleEntrySelected(schedule_entry_key);
}
