// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef THEATERMODEL_H
#define THEATERMODEL_H

#include "data/cinema.h"

#include <QString>
#include <QAbstractListModel>

class CinemaSchedule;
class Cinema;

class TheaterModel : public QAbstractListModel
{
    Q_OBJECT
public:
    enum {
        SortRole = Qt::UserRole,
        TheaterItemRole,
        TheaterKeyRole
    };
public:
    TheaterModel(const CinemaSchedule *, QObject *parent = 0);

    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;

private:
    const CinemaSchedule *_cinema_schedule;
};

class TheaterItem
{
public:
    TheaterItem() {}
    TheaterItem(const Cinema &cinema) : _cinema(cinema) {}
    const Cinema *GetCinema() const { return &_cinema; }
private:
    Cinema _cinema;
};

Q_DECLARE_METATYPE(TheaterItem);

#endif // THEATERMODEL_H
