// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "itemmodelsortclient.h"

#include "itemmodelsortproxy.h"
#include "itemmodelsortcontroller.h"

#include <iostream>

ItemModelSortClient::ItemModelSortClient(ItemModelSortController *controller, QObject *parent)
    : QObject(parent),
    _proxy(new ItemModelSortProxy(controller)),
    _model(0),
    _task_id(0),
    _intermediate(false)
{
    connect(this, SIGNAL(Sort(QAbstractItemModel*)), _proxy, SLOT(Sort(QAbstractItemModel*)));
    connect(_proxy, SIGNAL(SortFinished(QAbstractItemModel*)), this, SLOT(SortFinished(QAbstractItemModel*)));
    _proxy->moveToThread(controller->thread());
}

void ItemModelSortClient::Sort(QAbstractItemModel *model, int task_id, bool intermediate)
{
    _model = model;
    _task_id = task_id;
    _intermediate = intermediate;
    //std::cout << "Start sorting model " << model << " with intermediate = " << intermediate << std::endl;
    emit Sort(model);
}

void ItemModelSortClient::SortFinished(QAbstractItemModel *model)
{
    //std::cout << "Finished sorting model " << model << " with intermediate = " << _intermediate << std::endl;
    emit SortFinished(model, _task_id, _intermediate);
    deleteLater();
}
