// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ASYNCCALLPROXY_H
#define ASYNCCALLPROXY_H

#include <QObject>

namespace AsyncCallPrivate {

    class CallProxyBase {
        template<class OBJECT, typename METHOD> friend class AsyncCall0;
        template<class OBJECT, typename METHOD, typename ARG1> friend class AsyncCall1;
        template<class OBJECT, typename METHOD, typename ARG1, typename ARG2> friend class AsyncCall2;

    protected:
        CallProxyBase();

    public:
        virtual ~CallProxyBase();

    public:
        virtual void Call();
    };

    class AsyncCallProxy : public QObject
    {
        Q_OBJECT
    public:
        explicit AsyncCallProxy(QObject *parent = 0);

    public:
        Q_SLOT void Call(CallProxyBase *);

    };

}

#endif // ASYNCCALLPROXY_H
