// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CINEMA_H
#define CINEMA_H

#include "cinemakey.h"

#include <QString>

class Cinema
{
public:
    Cinema();

    CinemaKey GetKey() const { return CinemaKey(_name, _address); }

    bool IsValid() const { return !_name.isEmpty(); }

    QString GetName() const { return _name; }
    void SetName(const QString &name) { _name = name; }

    QString GetAddress() const { return _address; }
    void SetAddress(const QString &address) { _address = address; }

    QString GetMoviesUrl() const { return _movies_url; }
    void SetMoviesUrl(const QString &movies_url) { _movies_url = movies_url; }

    QString GetTelephone() const { return _telephone; }
    void SetTelephone(const QString &telephone) { _telephone = telephone; }

private:
    QString _name;
    QString _address;
    QString _movies_url;
    QString _telephone;
};

#endif // CINEMA_H
