// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "timeutils.h"

TimeUtils::TimeUtils()
{
}

QTime TimeUtils::FromTimeString(const QString &time)
{
    int pos = 0;
    int n = time.length();
    int hours = 0;
    int minutes = 0;
    int m = 0;
    while (pos < n && time[pos].isDigit()) {
        hours = 10 * hours + time[pos].digitValue();
        ++pos;
        ++m;
    }
    if (m == 0 || pos >= n || time[pos] != ':') {
        return QTime();
    }
    ++pos;
    m = 0;
    while (pos < n && time[pos].isDigit()) {
        minutes = 10 * minutes + time[pos].digitValue();
        ++pos;
        ++m;
    }
    if (m == 0) {
        return QTime();
    }
    if (pos < n) {
        QString s = time.mid(pos);
        if (s.compare("pm", Qt::CaseInsensitive) == 0) {
            if (hours < 12) {
                hours += 12;
            }
        } else if (s.compare("am", Qt::CaseInsensitive) == 0) {
            // nothing to do
        } else {
            return QTime();
        }
    } else {
        // assume pm as default
        if (hours < 12) {
            hours += 12;
        }
    }
    return QTime(hours, minutes);
}

QString TimeUtils::ToTimeString(const QTime &time)
{
    QString s = time.toString(Qt::SystemLocaleShortDate);
    return s;
}

QString TimeUtils::ToDateString(const QDate &date)
{
    QString date_name;
    if (date == QDate::currentDate()) {
        date_name = QObject::tr("Today", "DayPainter");
    } else if (date == QDate::currentDate().addDays(1)) {
        date_name = QObject::tr("Tomorrow", "DayPainter");
    } else {
        date_name = date.toString("dddd");
    }
    return date_name;
}
