// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "styleutils.h"

#ifdef Q_WS_MAEMO_5
#include <QMaemo5Style>
#endif

#include <QPalette>

StyleUtils::StyleUtils()
{
}

QColor StyleUtils::GetColor(const QPalette &palette, StandardColor standard_color)
{
#ifdef Q_WS_MAEMO_5
    Q_UNUSED(palette);
    switch (standard_color)
    {
    case DefaultBackgroundColor:
        return QMaemo5Style::standardColor("DefaultBackgroundColor");
    case DefaultTextColor:
        return QMaemo5Style::standardColor("DefaultTextColor");
    case SecondaryTextColor:
        return QMaemo5Style::standardColor("ActiveTextColor");
    default:
        return QColor();
    }
#else
    QColor color;
    switch (standard_color)
    {
    case DefaultBackgroundColor:
        return palette.color(QPalette::Window);
    case DefaultTextColor:
        return palette.color(QPalette::WindowText);
    case SecondaryTextColor:
         color = palette.color(QPalette::WindowText);
         color.setAlpha(160);
         return color;
    default:
        return palette.color(QPalette::WindowText);
    }
#endif
}

QColor StyleUtils::GetScheduleTimeColor(const QPalette &palette, QTime time)
{
    Q_UNUSED(time);
#ifdef Q_WS_MAEMO_5
    return QMaemo5Style::standardColor("DefaultTextColor");
#else
    QColor color = palette.color(QPalette::WindowText);
    return color;
#endif
}

QColor StyleUtils::GetDayTextColor(const QPalette &palette, const QDate &date)
{
    Q_UNUSED(date);
#ifdef Q_WS_MAEMO_5
    QColor color = QMaemo5Style::standardColor("DefaultTextColor");
    color.setAlpha(160);
    return color;
#else
    QColor color = palette.color(QPalette::WindowText);
    color.setAlpha(160);
    return color;
#endif
}

QColor StyleUtils::GetDayBackgroundColor(const QPalette &palette, const QDate &date)
{
    Q_UNUSED(date);
#ifdef Q_WS_MAEMO_5
    QColor color = QMaemo5Style::standardColor("DefaultTextColor");
    color.setAlpha(48);
    return color;
#else
    QColor color = palette.color(QPalette::WindowText);
    color.setAlpha(48);
    return color;
#endif
}

StyleUtils *StyleUtils::_instance = 0;

StyleUtilsSingleton::StyleUtilsSingleton()
{
    StyleUtils::_instance = &_instance;
}
