// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "aboutdialog.h"
#include "ui_aboutdialog.h"

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AboutDialog)
{
    ui->setupUi(this);
    ui->_button_box->addButton(ui->_done_button, QDialogButtonBox::AcceptRole);
    ui->_button_box->addButton(ui->_contact_button, QDialogButtonBox::ActionRole);
    //QPalette palette = ui->_about_text->palette();
    //palette.setColor(QPalette::Base, palette.color(QPalette::Window));
    //palette.setColor(QPalette::Text, palette.color(QPalette::WindowText));
    //ui->_about_text->setPalette(palette);
    connect(ui->_button_box, SIGNAL(accepted()), this, SLOT(deleteLater()));
    connect(ui->_button_box, SIGNAL(rejected()), this, SLOT(deleteLater()));
    connect(ui->_contact_button, SIGNAL(clicked()), this, SLOT(deleteLater()));
    connect(ui->_contact_button, SIGNAL(clicked()), this, SIGNAL(ContactAuthor()));
}

AboutDialog::~AboutDialog()
{
    delete ui;
}
