// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "itemmodelsortcontroller.h"

#include "data/cinemaschedule.h"
#include "utils/assertedlocker.h"

#include <QAbstractItemModel>
#include <QThread>

ItemModelSortController::ItemModelSortController(CinemaSchedule *cinema_schedule)
    : _cinema_schedule(cinema_schedule)
{
}

void ItemModelSortController::Sort(QAbstractItemModel *model)
{
    AssertedReadLocker(_cinema_schedule->GetLock());
    model->sort(0);
    //sleep(2);
}
