// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ASSERTEDLOCKER_H
#define ASSERTEDLOCKER_H

class AssertedLock;

class AssertedLocker
{
public:
    enum LockMode { READ, WRITE };

public:
    AssertedLocker(AssertedLock *, LockMode mode);
    ~AssertedLocker();

private:
    AssertedLock *_lock;
};

class AssertedReadLocker : public AssertedLocker
{
public:
    AssertedReadLocker(AssertedLock *lock) : AssertedLocker(lock, READ) {}
};

class AssertedWriteLocker : public AssertedLocker
{
public:
    AssertedWriteLocker(AssertedLock *lock) : AssertedLocker(lock, WRITE) {}
};

#endif // ASSERTEDLOCKER_H
