// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "backgroundlabel.h"

#include <QPainter>
#include <QFont>

static const int MINIMUM_FONT_SIZE = 40;

BackgroundLabel::BackgroundLabel(QWidget *parent)
    : QWidget(parent),
    _cached_label_font_size(0),
    _cached_label_alignment(Qt::AlignHCenter | Qt::AlignTop)
{
}

void BackgroundLabel::SetLabelText(const QString &label_text)
{
    _label_text = label_text;
    _cached_label_font_size = 0;
    update();
}

void BackgroundLabel::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event);

    QPainter painter(this);

    QFont label_font = font();
    label_font.setWeight(QFont::Black);

    painter.translate(rect().width(), 0);
    painter.rotate(90);

    QRect widget_rect = painter.worldTransform().inverted().mapRect(rect());
    if (_cached_label_font_size <= 0 || widget_rect != _cached_widget_rect) {
        _cached_widget_rect = widget_rect;
        _cached_label_rect = widget_rect;
        _cached_label_rect.setTop(_cached_label_rect.top() + 20);
        _cached_label_alignment = Qt::AlignHCenter | Qt::AlignTop;
        int font_size = 80;

        for (;;) {
            label_font.setPixelSize(font_size);
            painter.setFont(label_font);
            QRect label_rect = painter.boundingRect(_cached_label_rect, _cached_label_alignment, _label_text);
            if (label_rect.x() < _cached_widget_rect.x()
                || label_rect.y() < _cached_widget_rect.y()
                || label_rect.width() > _cached_widget_rect.width()
                || label_rect.height() > _cached_widget_rect.height()) {
                font_size = font_size * 0.9;
                if (font_size < MINIMUM_FONT_SIZE) {
                    font_size = MINIMUM_FONT_SIZE;
                    _cached_label_alignment = Qt::AlignLeft | Qt::AlignTop;
                    break;
                }
            } else {
                break;
            }
        }
        _cached_label_font_size = font_size;
    } else {
        label_font.setPixelSize(_cached_label_font_size);
        painter.setFont(label_font);
    }
    QColor text_color = palette().color(QPalette::WindowText);
    text_color.setAlpha(32);
    painter.setPen(text_color);
    painter.drawText(_cached_label_rect, _cached_label_alignment, _label_text);
}
