// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef RATINGPROVIDER_H
#define RATINGPROVIDER_H

#include <QVector>

class QPixmap;

class RatingProvider
{
    friend class RatingSingleton;
private:
    RatingProvider();

public:
    static RatingProvider *INSTANCE() { return _instance; }
    QPixmap GetRating(double percentage);

private:
    void Load();

private:
    static RatingProvider *_instance;
    QVector<QPixmap> _rating_stars;
};

class RatingSingleton
{
public:
    RatingSingleton();

private:
    RatingProvider _instance;
};

#endif // RATINGPROVIDER_H
