// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIEWINDOW_H
#define MOVIEWINDOW_H

#include "abstractmainwindow.h"
#include "data/scheduleentrykey.h"

#include <QModelIndex>

class CinemaSchedule;
class QAbstractItemModel;

namespace Ui {
    class MovieWindow;
}

class MovieWindow : public AbstractMainWindow {
    Q_OBJECT
public:
    explicit MovieWindow(CinemaSchedule *cinema_schedule, QWidget *parent = 0);
    ~MovieWindow();

public:
    Q_SLOT void SetMovieName(QString movie_name);
    Q_SLOT void SetMovieScheduleModel(QAbstractItemModel *movie_schedule_model);
    Q_SLOT void SetError(QString error_text);

    bool IsIdle();

public:
    Q_SIGNAL void ScheduleEntrySelected(ScheduleEntryKey);

protected:
    void changeEvent(QEvent *e);

private:
    Q_SLOT void ScheduleEntrySelected(QModelIndex);

private:
    Ui::MovieWindow *ui;
    CinemaSchedule *_cinema_schedule;
    QAbstractItemModel *_movie_schedule_model;
};

#endif // MOVIEWINDOW_H
