// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef LOCATIONCONTROLLER_H
#define LOCATIONCONTROLLER_H

#include "data/location.h"

#include <QObject>

class MainWindow;
class Settings;

class LocationController : public QObject
{
    Q_OBJECT
public:
    explicit LocationController(MainWindow *main_window, Settings *settings);

public:
    Q_SLOT void OpenLocationDialog();

    void CancelAllGpsSearchs();

public:
    Q_SIGNAL void Search(Location location);

private:
    Q_SLOT void SearchLocationFromCityDatabase(Location location);
    Q_SLOT void SearchLocation(Location location);
    Q_SLOT void SearchGPS();
    Q_SLOT void CancelLocation();
    Location CleanLocation(const Location &location);
    void RememberLocation(const Location &location);

    Q_SLOT void GpsSearchStarted(int search_task_id);
    Q_SLOT void GpsPositionUpdate(int search_task_id);
    Q_SLOT void GpsSearchForTownStarted(int search_task_id);
    Q_SLOT void GpsTownUpdate(int search_task_id, QString town);
    Q_SLOT void GpsSearchError(int search_task_id);
    Q_SLOT void GpsSearchFinished(int search_task_id, bool success);

private:
    MainWindow *_main_window;
    Settings *_settings;
    int _active_search_task_id;
};

#endif // LOCATIONCONTROLLER_H
