#include <QDeclarativeView>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QPixmap>

#include "viewphotodetails.h"
#include "viewmessagecontents.h"

ViewPhotoDetails::ViewPhotoDetails(const QUrl url, QWidget *parent)
    : QWidget(parent)
    , m_view(0)
    , m_message(0)
    , m_photoUrl(url)
    , m_rotation(0)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setWindowFlags(windowFlags() | Qt::Window);

    m_message = new ViewMessageContents(m_photoUrl, this);

    m_view = new QDeclarativeView();
    m_view->engine()->addImportPath(QLatin1String("/opt/qtm12/imports"));
    m_view->rootContext()->setContextProperty("controller", this);
    m_view->setResizeMode(QDeclarativeView::SizeRootObjectToView);
    m_view->setSource(QUrl("qrc:/qml/PhotoDetails.qml"));
    m_view->setWindowFlags(m_view->windowFlags() | Qt::Window);
    m_view->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    QPushButton *rotateLeft = new QPushButton(this);
    rotateLeft->setIconSize(QSize(32, 32));
    rotateLeft->setIcon(QIcon(":/rotate_left.svg"));
    connect(rotateLeft, SIGNAL(clicked()), this, SLOT(rotateLeft()));

    QPushButton *rotateRight = new QPushButton(this);
    rotateRight->setIconSize(QSize(32, 32));
    rotateRight->setIcon(QIcon(":/rotate_right.svg"));
    connect(rotateRight, SIGNAL(clicked()), this, SLOT(rotateRight()));

    QPushButton *button = new QPushButton(this);
    connect(button, SIGNAL(clicked()), this, SLOT(acceptClicked()));
    button->setText(QLatin1String(" Continue "));

    QVBoxLayout *buttonLayout = new QVBoxLayout(this);
    buttonLayout->setContentsMargins(0, 0, 0, 0);
    buttonLayout->addWidget(rotateLeft);
    buttonLayout->addWidget(rotateRight);
    buttonLayout->addStretch(1);
    buttonLayout->addWidget(button);

    QWidget *buttonWidget = new QWidget(this);
    buttonWidget->setLayout(buttonLayout);

    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->addWidget(m_view);
    layout->addWidget(buttonWidget);

    setLayout(layout);
}

ViewPhotoDetails::~ViewPhotoDetails()
{
    delete m_view;
}

void ViewPhotoDetails::acceptClicked()
{
    m_message->setRotation(m_rotation);
    m_message->showMaximized();
}

void ViewPhotoDetails::rotateLeft()
{
    m_rotation -= 90;
    if (m_rotation < 0) {
        m_rotation += 360;
    }
    emit rotationChanged();
}

void ViewPhotoDetails::rotateRight()
{
    m_rotation += 90;
    m_rotation = m_rotation % 360;
    emit rotationChanged();
}
