#ifndef VIEWPHOTODETAILS_H
#define VIEWPHOTODETAILS_H

#include <QWidget>
#include <QUrl>

class QDeclarativeView;
class ViewMessageContents;

class ViewPhotoDetails : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(QUrl url READ url CONSTANT)
    Q_PROPERTY(int rotation READ rotation NOTIFY rotationChanged)

public:
    explicit ViewPhotoDetails(const QUrl url, QWidget *parent);
    ~ViewPhotoDetails();

    QUrl url() const { return m_photoUrl; }
    int rotation() const { return m_rotation; }

signals:
    void rotationChanged() const;

private slots:
    void acceptClicked();
    void rotateLeft();
    void rotateRight();

private:
    QDeclarativeView *m_view;
    ViewMessageContents *m_message;
    const QUrl m_photoUrl;
    int m_rotation;

};

#endif // VIEWPHOTODETAILS_H
