#ifndef VIEWMESSAGECONTENTS_H
#define VIEWMESSAGECONTENTS_H

#include <QLineEdit>
#include <QComboBox>
#include <QScrollArea>

#include "mouho.h"

class ViewMessageContents : public QScrollArea
{
    Q_OBJECT

public:
    explicit ViewMessageContents(const QUrl &url, QWidget *parent = 0);
    ~ViewMessageContents();

    void setRotation(int rotation);

private slots:
    void sendMessage();
    QString& encodeXML(QString source);

private:
    QString getSizeLiteral(const QSize &size, bool swap) const;
    void scaleSize(int width, int height, QSize &size);

private:
    QWidget *m_parent;
    QUrl m_photoUrl;
    int m_rotation;
    QLineEdit *m_message;
    QLineEdit *m_caption;
    QComboBox *m_channelOptions;
    QComboBox *m_sizeOptions;
    ChannelList m_channelList;

};

#endif // VIEWMESSAGECONTENTS_H
