/**
 *  Copyright  2010 Digia Plc
 *  Copyright  2010 Nokia Corporation
 *
 *  All rights reserved.
 *
 *  Nokia and Nokia Connecting People are registered trademarks of
 *  Nokia Corporation.
 *  Java and all Java-based marks are trademarks or registered
 *  trademarks of
 *  Sun Microsystems, Inc. Other product and company names
 *  mentioned herein may be
 *  trademarks or trade names of their respective owners.
 *
 *
 *  Subject to the conditions below, you may, without charge:
 *
 *    Use, copy, modify and/or merge copies of this software and
 *     associated documentation files (the "Software")
 *
 *    Publish, distribute, sub-licence and/or sell new software
 *     derived from or incorporating the Software.
 *
 *
 *  This file, unmodified, shall be included with all copies or
 *  substantial portions
 *  of the Software that are distributed in source code form.
 *
 *  The Software cannot constitute the primary value of any new
 *  software derived
 *  from or incorporating the Software.
 *
 *  Any person dealing with the Software shall not misrepresent
 *  the source of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *  KIND, EXPRESS OR IMPLIED,
 *  INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A
 *  PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *  WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 *  CONNECTION WITH THE
 *  SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
import Qt 4.7
import "includes"
import "gradients"

Rectangle {
    id: structure

    property CLStyle style: CLStyle {}
    property color borderColor: style.borderColor
    property int borderWidth: style.borderWidth
    property color bgColor: style.bgColor
    property real roundness: style.roundness
    property bool gradientBgOn: style.gradientBgOn
    property Gradient gradientBg: style.gradientBg
    property Gradient nullGradient: Gradient{}

    function newRadius() {
        if (structure.height < structure.width) return Math.round( (structure.height/2) * structure.roundness);
        return Math.round((structure.width/2) * structure.roundness);
    }

    width: 200
    height: 200
    smooth: true
    color: bgColor
    gradient: (gradientBgOn)?gradientBg:nullGradient
    border.width: borderWidth
    border.color: borderColor
    radius: newRadius()
}
