#ifndef MOUHO_H
#define MOUHO_H

#include <QObject>

#include "networkhandler.h"
#include "config.h"

class Mouho : public QObject
{
    Q_OBJECT

public:
    static Mouho& instance() {
        static Mouho instance;
        return instance;
    }

    static QString version() { return "Mouhoposter 1.0"; }
    ChannelList channels() const { return m_channels; }
    void initChannels();
    void post(QSharedPointer<Image> image);
    Config& config() const { return *m_config; }
    void showBanner(const QString &value) const;

signals:
    void channelListReceived(bool success) const;
    void postStarted() const;
    void postFinished() const;

private slots:
    void setChannels(const ChannelList &channels);
    void postCompleted(QSharedPointer<Image> image);
    void postFailed(const QString &value);
    void channelListFailed(const QString &value);

private:
    Mouho();
    Mouho(const Mouho&);
    void operator=(const Mouho&);

private:
    Config *m_config;
    NetworkHandler *m_handler;
    ChannelList m_channels;

};

#endif // MOUHO_H
