#include "config.h"

static const QString XOR_KEY = "f92bb1ead98d08658272aadcb4f7bf15d719f0b4aa2f9e181ae069275af4cb83";

Config::Config(QObject *parent)
	: QObject(parent)
{
}

QString Config::username() const
{
    return m_settings.value("username").toString();
}

void Config::setUsername(QString value)
{
    m_settings.setValue("username", value);
}

QString Config::password() const
{
    return decodeString(m_settings.value("password").toString());
}

void Config::setPassword(QString value)
{
    m_settings.setValue("password", encodeString(value));
}

QString Config::defaultChannel() const
{
    return m_settings.value("channel").toString();
}

void Config::setDefaultChannel(QString value)
{
    m_settings.setValue("channel", value);
}

int Config::defaultSize() const
{
    return m_settings.value("size").toInt();
}

void Config::setDefaultSize(int value)
{
    m_settings.setValue("size", value);
}

/**
 * Encode the string. Just a simple xor with constant key
 * to make sure the password is not plain-text readable
 */
QString Config::encodeString(QString value) const
{
    if (value.isEmpty()) {
        return QString();
    } else {
        QByteArray xord(value.length(), '0');
        for (int i = 0; i < value.length(); i++) {
            xord[i] = value.at(i).toAscii() ^ XOR_KEY.at(i).toAscii();
        }
        return xord.toBase64().data();
    }
}

/**
 * Decode the encoded string.
 */
QString Config::decodeString(QString value) const
{
    if (value.isEmpty()) {
        return QString();
    } else {
        QByteArray plain = QByteArray::fromBase64(value.toLatin1());
        QByteArray xord(plain.length(), '0');
        for (int i = 0; i < plain.length(); i++) {
            xord[i] = plain.at(i) ^ XOR_KEY.at(i).toAscii();
        }
        return xord.data();
    }
}
