// MORTAR shot image (w) 1998-1999 by Eero Tamminen

#include "colors.inc"


#declare spike =
cone {
	<0,  0.9, 0>, 0
	<0, -0.1, 0>, 0.5
	scale 0.4
	translate 0.8 * y
}

// mace
union {
	// ball
	sphere {
		<0, 0, 0>, 0.8
	}

	// top spike
	object {
		spike
	}

	// top ring of spikes
	#declare turn = 0;
	#while (turn < 360)
	object {
		spike
		rotate z * 45
		rotate y * turn
	}
	#declare turn = turn + 90;
	#end
	
	// middle ring of spikes
	#declare turn = 0;
	#while (turn < 360)
	object {
		spike
		rotate z * 90
		rotate y * turn
	}
	#declare turn = turn + 45;
	#end

	// bottom ring of spikes
	#declare turn = 0;
	#while (turn < 360)
	object {
		spike
		rotate z * 135
		rotate y * turn
	}
	#declare turn = turn + 90;
	#end
	
	// bottom spike
	object {
		spike
		rotate z * 180
	}

	pigment { White }
	normal {
		waves 0.6
		turbulence 1.5
		scale 0.7
	}
	finish {
		phong 1.5
		phong_size 50
		brilliance 8
		metallic
	}

	// animation
	rotate clock * 360 * z
}

/*
sphere {
	<0, 0, 0>, 1
	pigment { color White }
	finish { Metal }
}
*/


// general lighting
light_source {
	<-4, -4, -10>
	color White
}
light_source {
	<2, 3, -8>
	color White
}

camera {
	location <1, 1, -2>
	look_at  <0, 0, 0>
	right x			// 1:1 aspect ratio
}
