/*
 * A cannon image for the Mortar game (adapted from one one I
 * adapted for Airstrike game from Mortar one by removing firing
 * animation)
 *
 * Origo is positioned at the middle of the cannon butt.
 *
 * (w) 2002 by Eero Tamminen
 */

#include "colors.inc"
#include "textures.inc"

#declare heading = clock;


#declare pipe =
difference {
	union {
		intersection {
			sphere {
				0, 1
				scale <8, 2.4, 2.4>
			}
			box {
				// remove butt & head...
				<0, -3, -3>, <7, 3, 3>
			}
		}
		sphere {
			// round off the butt
			0, 2.4
		}
		torus {
			// ring around the head
			1, 0.4
			rotate 90 * z
			translate 7 * x
		}
		// nubs to hang the cannon from
		cylinder {
			<0, 0, -3.2>, <0, 0, 3.2>, 0.3
		}
		sphere {
			0, 1
			scale <0.4, 0.4, 0.2>
			translate -3.2 * z
		}
		sphere {
			0, 1
			scale <0.4, 0.4, 0.2>
			translate 3.2 * z
		}
	}
	cylinder {
		// hole for cannonball
		<-1, 0, 0>, <8, 0, 0>, 1
	}
}


#declare depth = 3;

#declare side =
difference {
	intersection {
		sphere {
			0, 1
			scale <2, 4, 1>
		}
		box {
			<-2, 0, -0.25>, <2, 5, 0.25>
		}
	}
	cylinder {
		<0, depth, -0.3>, <0, depth, 0.3>, 0.31
	}
	translate -depth * y
}

#declare base =
union {
	object {
		side
		translate 2.75 * z
	}
	object {
		side
		translate -2.75 * z
	}
	intersection {
		cylinder {
			<0, 0.5-depth, 0>, <0, -depth, 0>, 4.5
		}
		box {
			<-4.1, 0.51-depth, -3.1>, <4.1, -0.1-depth, 3.1>
		}
	}
}


// cannon
union {
	object {
		pipe
		scale <0.6, 1, 1>
		rotate heading * z
	}
	object {
		base
	}

	pigment { Gray90 }
	finish { Metal }
}

camera {
	location <0, 0.5, -10.2>
	look_at  <0, 0.5, 0>
	right x
}

light_source {
	<-5, 4, -8>
	color White
}
