/* 
 * MORTAR
 * 
 * -- sound functions for SDL mixer
 * 
 * This is free software; you can redistribute it and/or modify it
 * under the terms specified in the GNU Public Licence (GPL).
 *
 * Copyright (C) 2001 by Eero Tamminen
 */

#include "mortar.h"
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

static Mix_Music *Song[SONGS];
static Mix_Chunk *Sound[SOUNDS];


void snd_init(void)
{
	const char *songs[] = { "intro", "menu", "battle", "over", NULL };
	char *str, name[] = "sample_a";
	int idx;

	/* init audio and mixer (22khz, 16-bit mono) */
	if (SDL_Init(SDL_INIT_AUDIO) != 0 ||
	    Mix_OpenAudio(22050, AUDIO_S16, 1, 256) != 0) {
#ifdef DEBUG
		fprintf(stderr, "snd-sdl.c/snd_init(): SDL audio error: %s.\n", SDL_GetError());
#endif
		return;
	}

	/* set volume for background songs */
	str = get_string("volume");
	if (str && atoi(str)) {
		Mix_VolumeMusic(atoi(str));
	}

	/* setup midi songs */
	for (idx = 0; idx < SONGS; idx++) {

		if (!songs[idx]) {
			break;
		}
		str = get_string(songs[idx]);
		if (str) {
			Song[idx] = Mix_LoadMUS(str);
#ifdef DEBUG
			if (!Song[idx]) {
				fprintf(stderr, "mortar: failed loading sample '%s' (%s)\n", str, SDL_GetError());
			}
#endif
		}
	}

	/* setup effect sounds */
	for (idx = 0; idx < SOUNDS; idx++) {

		name[7] = 'a' + idx;
		str = get_string(name);
		if (str) {
			Sound[idx] = Mix_LoadWAV(str);
#ifdef DEBUG
			if (!Sound[idx]) {
				fprintf(stderr, "mortar: failed loading song '%s' (%s)\n", str, SDL_GetError());
			}
#endif
		}
	}
}

void snd_exit(void)
{
	Mix_HaltMusic();
	Mix_HaltChannel(-1);
	Mix_CloseAudio();
}


void snd_play(int idx)
{
#ifdef DEBUG
	if (idx < 0 || idx >= SOUNDS) {
		win_exit();
		fprintf(stderr, "snd-sdl.c/snd_play(): illegal sound ID!\n");
		exit(-1);
	}
#endif
	if (Sound[idx]) {
		/* play once on the first free channel */
		Mix_PlayChannel(-1, Sound[idx], 0);
	}
}

void snd_flush(void)
{
	/* called every frame */
}

void snd_sync(void)
{
	/* wait for sounds to end */
}


/* zero 'times' loops the song */
void song_play(int idx, int times)
{
#ifdef DEBUG
	if (idx < 0 || idx >= SONGS) {
		win_exit();
		fprintf(stderr, "snd-sdl.c/song_play(): illegal song ID!\n");
		exit(-1);
	}
#endif
	if (Song[idx]) {
		/* on SDL value means how many additional times */
		times--;
		/* play on the first free channel */
		Mix_FadeInMusic(Song[idx], times, 500);
	}
}

void song_stop(void)
{
	Mix_FadeOutMusic(500);
}
