#!/bin/sh
# helper script for building debian package from Mortar CVS

name=mortar

if [ $# -ne 1 ]; then
	echo "usage: ${0##*/} <version>"
	exit 1
fi
version=$1

if [ -d tmp ]; then
	echo "'tmp' already exists, remove it first"
	exit 1
fi
mkdir tmp
cd tmp

cvs export -r HEAD $name
mv $name $name-$version
cd $name-$version
dpkg-buildpackage -rfakeroot

ls -l tmp
