#!/usr/bin/env python
import pygtk
import gtk
import cairo
from gtk.gdk import Pixbuf
from gtk import Clipboard as clipboard
        
class ImagePanel(gtk.DrawingArea):
    def __init__(self, side, w, h):
        gtk.DrawingArea.__init__(self)
        self.pixbuf = None
        self.set_size_request(w/2, h)
        self.side = side
        self.pw = 0
        self.ph = 0
        self.wx = 0
        self.wy = 0
        self.ww = 0
        self.wh = 0
        self.zf = 1.0
        self.center = 0, 0
        self.tranzition = 0, 0
        self.expose_id = self.connect('expose_event', self.expose)
        self.user_xy = 0, 0
        self.device_xy = 0, 0
        self.frame = None
        self.unsel_points = None
        self.sel_points = None
        self.point_size = 14
            
    def load_image(self, filename):
        self.pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
        self.pw = self.pixbuf.get_width()
        self.ph = self.pixbuf.get_height()
        
    def align_center(self):
        self.wx, self.wy, self.ww, self.wh = self.get_allocation()
        self.center = self.ww/2, self.wh/2
                    
    def expose(self, w, e):
        self.align_center()
        self.update_panel(w, False)
    
    def update_panel(self, widget, action):
        ctx = self.window.cairo_create()
        ctx.save()   
        ctx.translate(*self.center)
        
        ctx.scale(self.zf, self.zf)
        ctx.translate(*self.tranzition)
        if self.pixbuf:
            ctx.set_source_pixbuf(self.pixbuf, -self.pw/2, -self.ph/2)
        ctx.paint()
        if self.frame:
                 self.update_frame(ctx)        
        if action:
            self.do_action(ctx)
        
        self.update_points(ctx)
        self.update_margin(ctx)
    
    def do_action(self, ctx):
        x, y = ctx.device_to_user(*self.user_xy)
        x = round(x)+self.pw/2
        y = round(y)+self.ph/2
        self.device_xy = x, y
        
    def update_frame(self, ctx):
        x, y , w, h = self.frame
        x = x - self.pw/2
        y = y - self.ph/2
        lw = 2 / self.zf
        ctx.set_line_width(lw)
        ctx.set_source_rgb(0,0,1)
        ctx.rectangle(x-lw/2, y-lw/2, w+lw, h+lw)
        ctx.stroke()
        ctx.set_line_width(lw)
        ctx.set_source_rgb(1,0,0)
        ctx.rectangle(x-lw, y-lw, w+2*lw, h+2*lw)
        ctx.stroke()
           
    def update_points(self, ctx):
        ctx.translate(-self.pw/2, -self.ph/2)
        u = self.unsel_points
        s = self.sel_points
        ps = self.get_point_size()
        if u:
            for i, p in enumerate(u):
                x, y = p
                ctx.set_source_rgb(0,0,0)
                ctx.rectangle(x-ps/2,y-ps/2,ps,ps)
                ctx.fill()
                ctx.set_source_rgb(1,1,1)
                ctx.set_line_width(ps/4)
                ctx.rectangle(x-ps/2,y-ps/2,ps,ps)
                ctx.stroke()
        if s:
            x, y = s
            ctx.set_source_rgb(1,0,0)
            ctx.rectangle(x-ps/2,y-ps/2,ps,ps)
            ctx.fill()
            ctx.set_source_rgb(0,1,1)
            ctx.rectangle(x-ps/2,y-ps/2,ps,ps)
            ctx.set_line_width(ps/4)
            ctx.stroke()
            
    def update_margin(self, ctx):
        ctx.restore()
        ctx.set_source_rgb(1,1,1)
        ctx.rectangle(8, 8 ,self.ww-16,self.wh-16)
        ctx.stroke()    
        ctx.set_source_rgb(0,0,0)
        ctx.rectangle(6, 6 ,self.ww-12,self.wh-12)
        ctx.stroke()  
               
    def translate(self, direction, dist):
        dist = dist / self.zf
        x, y = self.tranzition
        if direction == 'up':
            y += dist
        elif direction == 'down':
            y -= dist
        elif direction == 'left':
            x += dist
        elif direction == 'right':
            x -= dist
        self.tranzition = x, y
        
    def zoom(self, zoom, factor):
        zf = self.zf
        if zoom == 1:
            self.zf = zf * factor
        elif zoom == 2:
            self.zf = zf / factor
        else:
            self.zf = 1.0
          
    def get_point_size(self):
        return self.point_size / self.zf