#!/usr/bin/env python

import pygtk
import gtk
from application import App
import filehandler
import dialogs
import sys
import os
from time import time as clock
from time import sleep
import warnings

warnings.simplefilter('ignore', DeprecationWarning) 
         
class Main():
    def __init__(self):
        
        self.win = gtk.Window()
        self.win.connect('destroy', gtk.main_quit)
        self.win.connect("key-press-event", self.on_key_press)
        self.win.connect("enter_notify_event", self.enter_cb)
#        self.win.connect("leave_notify_event", self.leave_cb)
        
        self.title = "PyMorph"
        self.win.set_title(self.title)
        self.win.fullscreen()
        self.infobar = dialogs.Infobar()
        self.app = App(self.infobar)
        self.f_handler = filehandler.Filehandler()
        self.menu_items = (
            ("/File", None, None, 0, "<Branch>"),
            ("/File/Open", None, None, 0, "<Branch>"),
            ("/File/Open/Left Image", "<control>l", self.open_image, 0, "<Item>"),
            ("/File/Open/Right Image", "<control>r", self.open_image, 1, "<Item>"),
            ("/File/Save Single Image as", None, None, 0, "<Branch>"),
            ("/File/Save Single Image as/Left Image Morphed", None, self.save_as, 1, "<Item>"),
            ("/File/Save Single Image as/Right Image Morphed", None, self.save_as, 2, "<Item>"),
            ("/File/Save Single Image as/Midle Image", None, self.save_as, 0, "<Item>"),
            ("/File/Save Animation as", None, None, 0, "<Branch>"),
            ("/File/Save Animation as/Animation", None, self.save_anim_as, 3, "<Item>"),
            ("/File/Save Animation as/Only Left Animated", None, self.save_anim_as, 4, "<Item>"),
            ("/File/Save Animation as/Only Right Animated", None, self.save_anim_as, 5, "<Item>"),
            ("/File/Quit", "<control>q", gtk.main_quit, 0, "<Item>"),
            ("/Edit", None, None, 0, "<Branch>"),
            ("/Edit/Frame Size", None, self.app.set_frame_size, 0, "<Item>"),
            ("/Edit/Crop Images", "<control>c", self.app.crop, 0, "<Item>"),
            ("/Edit/sep1", None, None, 0, "<Separator>"),
            ("/Edit/Next Point", "n", self.app.select_point, 1, "<Item>"),
            ("/Edit/Privious Point", "p", self.app.select_point, 0, "<Item>"),
            ("/Edit/Delete Selected Point", "d", self.app.remove_point, 0, "<Item>"),
            ("/Edit/Clear Points", "c", self.app.clear_points, 0, "<Item>"),
            ("/View", None, None, 0, "<Branch>"),
            ("/View/Zoom In", "i", self.app.zoom, 1, "<Item>"),
            ("/View/Zoom Out", "o", self.app.zoom, 2, "<Item>"),
            ("/View/Zoom 100%", "z", self.app.zoom, 0, "<Item>"),
            ("/View/sep1", None, None, 0, "<Separator>"),
            ("/View/Side by Side", "m", self.app.set_view, 0, "<Item>"),
            ("/View/Left Picture", "l", self.app.set_view, 1, "<Item>"),
            ("/View/Right Picture", "r", self.app.set_view, 2, "<Item>"),
            ("/Settings", None, None, 0, "<Branch>"),
            ("/Settings/Distortion Mode/Perspective", None, self.app.morph.set_distort, 0, "<RadioItem>"),
            ("/Settings/Distortion Mode/Shepards", None, self.app.morph.set_distort, 1, "/Settings/Distortion Mode/Perspective"),
            ("/Settings/Distortion Mode/Bilinear", None, self.app.morph.set_distort, 2, "/Settings/Distortion Mode/Perspective"),
            ("/Help", None, None, 0, "<Item>")
            )
        hbox = gtk.HBox()
        hbox.pack_start(self.app.ipl)
        hbox.pack_start(self.app.ipr)
        
        self.menubar = self.get_menu(self.win)     
        vbox = gtk.VBox()
        tbox = gtk.HBox()
        tbox.pack_start(self.menubar)
        tbox.pack_start(self.infobar)
        vbox.pack_start(tbox)
        vbox.pack_start(self.app)
        
        self.app.add(hbox)
        self.win.add(vbox)
        self.win.show_all()
        
#        self.menubar.connect('enter_notify_event', self.menu_enter_cb)
#        self.menubar.connect('event_after', self.menu_leave_cb)
        gtk.main()
    
    def get_menu(self, window):
        ag = gtk.AccelGroup()
        item_factory = gtk.ItemFactory(gtk.MenuBar, "<main>", ag)    
        item_factory.create_items(self.menu_items)
        window.add_accel_group(ag)
        self.item_factory = item_factory
        return item_factory.get_widget("<main>")
        
    def open_image(self, d, w):
        if d:
            s = "right"
        else:
            s = "left"
        self.win.unfullscreen()
        self.f_handler.open_cb(self.app, s, self.win)
        self.win.fullscreen()

    def save_as(self, d, w):
        self.win.unfullscreen()
        s = self.f_handler.save_as_cb(self.app, 0, self.win)
        self.win.fullscreen()
        if s[0]:
                self.app.morph.save_single(s[1], d)
    
    def save_anim_as(self, data, w):
        self.win.unfullscreen()
        d = gtk.Dialog("Settings",
                   self.win,
                   gtk.DIALOG_MODAL,
                   (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
                    gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        sd = dialogs.AnimSettings()
        d.vbox.pack_start(sd)
        d.show_all()
        response = d.run()
        d.destroy()
        
        if response == gtk.RESPONSE_ACCEPT:
            num_frames, reverse, fps = sd.get()
            s = self.f_handler.save_as_cb(self.app, 1, self.win)
            if s[0]:
                s[2].destroy()
                self.win.fullscreen()
                self.app.morph.save_animation(s[1], int(num_frames), reverse, data, fps)
        else:
            self.win.fullscreen()
    
    def on_settings_hide(self, w):
        self.app.show()
        self.menubar.show()
        
    def enter_cb(self, w, e):
        self.app.tick()
            
    def on_key_press(self, widget, event):
        if (event.keyval == gtk.keysyms.Up):
            self.app.translate('up')
        elif (event.keyval == gtk.keysyms.Down):
            self.app.translate('down')
        elif (event.keyval == gtk.keysyms.Left):
            self.app.translate('left')
        elif (event.keyval == gtk.keysyms.Right):
            self.app.translate('right')
                    
if __name__ == '__main__':
    Main()
