#!/usr/bin/env python

import pygtk
import gtk
import os

class Filehandler():
    def __init__(self):
        self.filename = ''
        self.save_formats = (".png", ".jpg", ".bmp")
        self.animation_save_formats = (".gif", ".flv", ".swf")
        
    def open_cb(self, w, side, window):
        dialog = gtk.FileChooserDialog("Open...", window,
                                       gtk.FILE_CHOOSER_ACTION_OPEN)
 
        preview = gtk.Image()
        event_box = gtk.EventBox()
        event_box.add(preview)
        event_box.show()
        dialog.set_preview_widget(event_box)
        event_box.set_events(gtk.gdk.BUTTON_PRESS_MASK)

        preview.show()
        dialog.connect("update-preview", self.update_preview_cb, preview)          
        dialog.show()
        
        def button_press_cb(widget, event):
            dialog.hide()
            filename = dialog.get_filename().decode('utf-8')
            self.filename = os.path.join(filename)
            w.load_image(self.filename , side)
            dialog.destroy()
            
        event_box.connect("button_press_event", button_press_cb)
        
    def update_preview_cb(self, file_chooser, preview):
        pixbuf = None
        filename = file_chooser.get_preview_filename()
        if filename:
            filename = filename.decode('utf-8')
            try:
                pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
            except:
                file_chooser.set_preview_widget_active(False)
            if pixbuf:
                pixbuf = self.pixbuf_thumbnail(pixbuf, 256, 256, True)
                preview.set_from_pixbuf(pixbuf)
                file_chooser.set_preview_widget_active(True)
                
    def pixbuf_thumbnail(self, src, w, h, alpha=False):
        src2 = self.scale_proportionally(src, w, h)
        w2, h2 = src2.get_width(), src2.get_height()
        dst = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, alpha, 8, w, h)
        if alpha:
            dst.fill(0xffffff00)
        else:
            dst.fill(0xffffffff)
        src2.copy_area(0, 0, w2, h2, dst, (w-w2)/2, (h-h2)/2)
        return dst
        
    def scale_proportionally(self, pixbuf, w, h, shrink_only=True):
        width, height = pixbuf.get_width(), pixbuf.get_height()
        scale = min(w / float(width), h / float(height))
        if shrink_only and scale >= 1:
            return pixbuf
        new_width, new_height = int(width * scale), int(height * scale)
        new_width = max(new_width, 1)
        new_height = max(new_height, 1)
        return pixbuf.scale_simple(new_width, new_height, gtk.gdk.INTERP_BILINEAR)
        
    def save_as_cb(self, app, d, window):
        def_ext = app.morph.ext
        dialog = gtk.FileChooserDialog("Save as", window,
                                       gtk.FILE_CHOOSER_ACTION_SAVE,
                                       (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                        gtk.STOCK_SAVE, gtk.RESPONSE_OK))
        dialog.set_default_response(gtk.RESPONSE_OK)
        dialog.set_do_overwrite_confirmation(True)
        hbox = gtk.HBox()
        label = gtk.Label('Select Format:')
        combo = gtk.combo_box_new_text()
        if not d:
            sf = self.save_formats
            combo.append_text(def_ext)
        else:
            sf = self.animation_save_formats
        for ext in sf:
            if def_ext != ext:
                combo.append_text(ext)
        combo.set_active(0)
#        combo.connect('changed', save_format_changed_cb(0))
        hbox.pack_start(label)
        hbox.pack_start(combo, expand=False)
        dialog.set_extra_widget(hbox)
    
        def save_format_changed_cb(w):
            filename = dialog.get_filename()
            if filename:
                filename = filename.decode('utf-8')
                filename, ext = os.path.splitext(filename)
                if ext:
                    ext = combo.get_active_text()
                    fn = os.path.basename(filename)
                    dialog.set_current_name(fn+ext)
                    
        combo.connect('changed', save_format_changed_cb)
        dialog.show_all()
        response = dialog.run()    
        filename = dialog.get_filename()
        try:
            basename = os.path.basename(filename)
            dirname = os.path.dirname(filename)
            fn, ext = os.path.splitext(basename)
            if not ext:
                ext = combo.get_active_text()
                basename = basename + ext
            f = os.path.join(dirname, basename)
        except:
            f = None
        dialog.hide()  
        dialog.destroy()
        window.fullscreen()
        return response == gtk.RESPONSE_OK, f, dialog
    