#!/usr/bin/env python

import pygtk
import gtk
    
class AnimSettings(gtk.VBox):
    def __init__(self):
        gtk.VBox.__init__(self)
        num_label = gtk.Label(".   Number of Animation Frames         .")
        adj = gtk.Adjustment(5, 3, 100, 1, 10, 0)
        self.ne = gtk.SpinButton(adj)
        nbox = gtk.HBox()
        nbox.pack_start(num_label)
        nbox.pack_start(self.ne)
           
        fps_label = gtk.Label(".   Frames Per Second (fps)                   .")
        fps_adj = gtk.Adjustment(20, 1, 100, 1, 10, 0)
        self.fpse = gtk.SpinButton(fps_adj)
        fbox = gtk.HBox()
        fbox.pack_start(fps_label)
        fbox.pack_start(self.fpse)
           
        self.toggle_b = tb = gtk.ToggleButton("Forward and Backward Animation")
        tbox = gtk.HBox()
        tbox.pack_start(tb)
        self.pack_start(nbox)
        self.pack_start(fbox)
        self.pack_start(tbox)
        
    def get(self):
        n = self.ne.get_value_as_int()
        f = self.fpse.get_value_as_int()
        t = self.toggle_b.get_active()
        return n, t, f

def set_frame_size(width, height, max_width, max_height):
    d = gtk.Dialog("Frame Size",
               None,
               gtk.DIALOG_MODAL,
               (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
                gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
    hbox = gtk.HBox()
    wl = gtk.Label("Width")
    w_adj = gtk.Adjustment(width, 0, max_width, 1, 10, 0)
    ws = gtk.SpinButton(w_adj)
    hl = gtk.Label("Height")
    h_adj = gtk.Adjustment(height, 0, max_height, 1, 10, 0)
    hs = gtk.SpinButton(h_adj)
    hbox.pack_start(wl)
    hbox.pack_start(ws)
    hbox.pack_start(hl)
    hbox.pack_start(hs)
    d.vbox.pack_start(hbox)
    d.show_all()
    response = d.run()
    d.destroy()        
    if response == gtk.RESPONSE_ACCEPT:
        return ws.get_value_as_int(), hs.get_value_as_int() 
    
               
class Infobar(gtk.HBox):
    def __init__(self):
        gtk.HBox.__init__(self)
        self.label_1 = gtk.Label("")
        self.label_2 = gtk.Label("")
        self.label_3 = gtk.Label("MORPHER")
        self.pack_start(self.label_1)
        self.pack_start(self.label_2)
        self.pack_start(self.label_3)
        
    def coord_info(self, left_coord, right_coord):
        try:
            lx, ly = left_coord
            rx, ry = right_coord
            if lx == rx and ly == ry:
                text = '<span color="red"><b>' + str(lx) + "," + str(ly) + "</b></span>"
            else:
                text = '<span color="red"><b>' + str(lx) + "," + str(ly) + "      " +\
                    str(rx) + "," + str(ry) + "</b></span>"
            self.label_1.set_markup(text)
        except:
            pass
            
    def zoom_info(self, z):
        percent = z * 100
        text = '<span color="blue"><b>' + str(percent) + "%" + "</b></span>"
        self.label_2.set_markup(text)
        
        
        