#!/usr/bin/env python

import pygtk
import gtk
from panel import ImagePanel
from helpers import PointList, Frame
from magick import Morph
import dialogs
from time import sleep


class App(gtk.EventBox):
    def __init__(self, infobar):
        gtk.EventBox.__init__(self)
        w = 800
        h = 450
        self.infobar = infobar
        self.set_size_request(w, h)        
        self.frame = Frame()
        self.p_list = PointList()
        self.morph = Morph(self.p_list)
        self.ipl = ImagePanel('left', w, h)
        self.ipr = ImagePanel('right', w, h)
        self.button_handle = self.connect("button_press_event", self.button_press_cb)
        self.connect("button_release_event", self.button_release_cb)
        self.connect("motion_notify_event", self.motion_cb)
        self.connect("configure_event", self.focus_change_cb)
        self.view = "dual"
        self.edit_status = True
        self.frame_modify = True
        self.b_press = 0, 0
        self.selected = False
        self.grab = None

    def focus_change_cb(self, w, e):
        self.tick()
        
    def show_rendered(self):
        self.load_image(self.morph.l_rendered[-1], "right", rendered = True)
    
    def load_image(self, filename, side, rendered = False):
        if side == "left":
            self.ipl.load_image(filename)
        elif side == "right":
            self.ipr.load_image(filename)
        if not rendered:
            self.morph.save_to_temp(side, filename)
        if self.ipl.pixbuf and self.ipr.pixbuf:
            self.frame_modify = True
            self.frame.set_up(self.ipl.pw, self.ipl.ph, self.ipr.pw, self.ipr.ph, True)
            self.update_frames()
        self.tick()
        
    def set_frame_size(self, d, widget):
        f = self.frame
        w = f.width
        h = f.height
        mw = f.max_width
        mh = f.max_height
        wh = dialogs.set_frame_size(w, h, mw, mh)
        width, height = wh
        f.width = width
        f.height = height
        self.update_frames()
        self.frame_modify = True
        
    def crop(self, d, w):
        l = self.morph.crop("left", *self.frame.get('left'))
        r = self.morph.crop("right", *self.frame.get('right'))
        self.ipl.load_image(l)
        self.ipr.load_image(r)
        self.frame_modify = False
        self.frame.set_up(self.ipl.pw, self.ipl.ph, self.ipr.pw, self.ipr.ph, True)
        self.update_frames()
        self.tick()
                  
    def tick(self):
        a = self.get_allocation()
        x,y,w,h = a
        self.window.invalidate_rect((0,0,w,w), True)
        return True
        
    def update_frames(self):
        self.ipl.frame = self.frame.get("left")  
        self.ipr.frame = self.frame.get("right")
        self.tick()
                    
    def set_view(self, d, w):
        if d == 1:
            self.ipr.hide()
            self.ipl.show()
            d = "left"
        elif d == 2:
            self.ipl.hide()
            self.ipr.show()
            d = "right"
        else:
            self.ipl.show()
            self.ipr.show()
            d = "dual"
            
        self.view = d
        self.tick()
    
    def motion_cb(self, w, e):
        pass
           
    def button_press_cb(self,w ,e):
        self.b_press = e.x, e.y
        if not self.frame_modify:
            self.button_action(w, e.x, e.y, 'check')
        else:
            self.button_action(w, e.x, e.y, 'grab frame')
            
    def button_release_cb(self, w, e):
        
        x, y = self.b_press
        if self.frame_modify:
                self.button_action(w, e.x, e.y, 'move frame')
                return True
        if abs(e.x - x)>5 or abs(e.y - y)>5:
            if self.p_list.left != []:
                self.button_action(w, e.x, e.y, 'move')
        else:
            self.button_action(w, e.x, e.y, 'add')
        
    def button_action(self, w, ex, ey, action):
        if not self.edit_status:
            self.edit_status = True
            return
        view = self.view
        if self.view != 'right':
            if self.view == 'dual':
                if ex > self.ipl.ww:
                    view = 'right'
                else:
                    self.ipl.user_xy = ex, ey
                    view = 'left'
            else:
                self.ipl.user_xy = ex, ey
            self.ipl.update_panel(w, True)
            x, y = self.ipl.device_xy
            
        if view != 'left':
            if self.view == 'dual':
                if ex <= self.ipl.ww:
                    view = 'left'
                else:
                    x = ex - self.ipl.ww
                    self.ipr.user_xy = x, ey
            else:
                self.ipr.user_xy = ex, ey
            self.ipr.update_panel(w, True)
            x, y = self.ipr.device_xy
            
        x, y = int(round(x)), int(round(y))
        self.do_action(view, x, y, action)
        
    def do_action(self, side, x, y, action):      
        if action == 'check':
            sel = self.is_point_selected(side, x, y)
            if sel:
                self.p_list.select_point(side, *sel)
                self.update_panels()
                return True
        elif action == 'add':
            if not self.selected:
                self.p_list.add_point(side, x, y)
        elif action == 'move':
            if self.selected:
                self.p_list.move_point(side, x, y)
                self.selected = False
        elif action == 'move frame':
            if self.grab:
                s, gx, gy = self.grab
                if side == s:
                    dx = x - gx
                    dy = y - gy
                    self.frame.move_to(s, dx, dy)
                    self.update_frames()
                    self.grab = None
        elif action == 'grab frame':
            self.grab = (side, x, y)
        self.update_panels()
        
    def is_point_selected(self, side, x, y):
        ps = self.ipl.point_size + 10
        xps = range(x-ps,x+ps+1)
        yps = range(y-ps,y+ps+1)
        pl = self.p_list.get_all(side)
        for p in pl:
            xp, yp = p
            if xp in xps and yp in yps:
                self.selected = True
                return xp, yp
                
    def update_panels(self):
        self.ipl.unsel_points = self.p_list.get_unselected('left')
        l = self.ipl.sel_points = self.p_list.get_selected('left')
        self.ipr.unsel_points = self.p_list.get_unselected('right')
        r = self.ipr.sel_points = self.p_list.get_selected('right')
        if not self.frame_modify:
            self.infobar.coord_info(l, r)
        self.tick()
            
    def translate(self, direction):
        dist = 20
        self.ipl.translate(direction, dist)
        self.ipr.translate(direction, dist)
        self.tick()
    
    def zoom(self, d, w):
        factor = 2
        self.ipl.zoom( d, factor)
        self.ipr.zoom( d, factor)
        self.tick()
        self.infobar.zoom_info(self.ipl.zf)
    
    def clear_points(self, d, w):
        self.p_list.clear()
        self.ipl.unsel_points = None
        self.ipl.sel_points = None
        self.ipr.unsel_points = None
        self.ipr.sel_points = None
        self.update_panels()
        
    def remove_point(self, d, w):
        self.p_list.remove_selected()
        self.update_panels()
        
    def select_point(self, d, w):
        self.p_list.select_next(d)
        self.update_panels()
    