#!/usr/bin/env python

class PointList():
    def __init__(self):
        self.left = []
        self.right = []
    
    def clear(self):
        self.left = []
        self.right = []
        
    def side(self, side):
        return getattr(self, side)
        
    def mirror(self, side):
        if side == 'left':
            return getattr(self, 'right')
        if side == 'right':
            return getattr(self, 'left')
                
    def add_point(self, side, x, y):
        self.side(side).append((x, y))
        self.mirror(side).append((x, y))
        self.selected_idx = len(self.left)
        
    def select_point(self, side, x, y):
        i = self.side(side).index((x,y))
        self.side(side).remove((x,y))
        self.side(side).append((x,y))
        p = self.mirror(side).pop(i)
        self.mirror(side).append(p)
    
    def select_next(self, d):
        if d:
            self.side('left').append((self.side('left').pop(0)))
            self.side('right').append((self.side('right').pop(0)))
        else:
            self.side('left').insert(0, (self.side('left').pop()))
            self.side('right').insert(0, (self.side('right').pop()))
        
    def move_point(self, side, x, y):
        self.side(side)[-1] = x, y
        
    def remove_selected(self):
        self.left.pop()
        self.right.pop()
        
    def get_all(self, side):
        return self.side(side)
                  
    def get_unselected(self, side):
        return self.side(side)[:-1]
        
    def get_selected(self, side):
        if self.side(side) != []:
            return self.side(side)[-1]
            
class Frame():
    def __init__(self):
        self.width = 0
        self.height = 0
        self.max_width = 0
        self.max_height = 0
        self.left_coord = 0, 0
        self.right_coord = 0, 0
        self.left_pic_coord = 0, 0
        self.right_pic_coord = 0, 0
        self.liw = 0
        self.lih = 0
        self.riw = 0
        self.rih = 0
        
    def set_up(self, lw, lh, rw, rh, cropped):
        self.width = min(lw, rw)
        self.height = min(lh, rh)
        self.liw = lw
        self.lih = lh
        self.riw = rw
        self.rih = rh
        if cropped:
            self.left_coord = self.left_pic_coord
            self.right_coord = self.right_pic_coord
        self.max_width = self.width
        self.max_height = self.height
    
    def get(self, side):
        w = self.width
        h = self.height
        if side == "left":
            x , y = self.left_coord
        elif side == "right":
            x, y = self.right_coord
        if w and h:
            return x, y, w, h
        
    def move_to(self, side, x, y):
        w = self.width
        h = self.height
        if side == 'left':
            lx, ly = self.left_coord
            x = lx + x
            y = ly + y
            x = clamp(0, x, self.liw - w)
            y = clamp(0, y, self.lih - h)
            self.left_coord = x, y   
        if side == 'right':
            rx, ry = self.right_coord
            x = rx + x
            y = ry + y
            x = clamp(0, x, self.riw - w)
            y = clamp(0, y, self.rih - h)
            self.right_coord = x, y
            

def clamp(min_x, x, max_x):
    return max(min_x, min(x, max_x)) 
            