/*******************************************************************************
 * Copyright (c) 2007-2008 INdT, (c) 2009 Nokia.
 *
 * This code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 *
 */

/*
 ============================================================================
 Name        : main.c
 Author      : Dart
 Version     : 1.2
 Description : Hildon GUI Application in C
 ============================================================================
 */

/* Sun Nov 01 16:33:34 2009 lcuk : added focus event handlers to ensure no drained battery when in the background */
/* Sun Nov 01 16:33:34 2009 lcuk : discussed in #maemo irc with RST38H, qwerty12 and a few others prior to implementing */

/* Includes */
#include <hildon/hildon-program.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <libosso.h>
#include <stdio.h>
#include <string.h>

#include <pulse/simple.h>
#include <pulse/error.h>
#include <pulse/gccmacro.h>
#include <gst/gst.h>

#include "localisation.h"
/* Defines to add the application to dbus and keep it running
 * Please do not modify "APP_NAME" (or other defines) to different name
 */
#define APP_NAME "moobox"
#define APP_VER "1.2"
#define APP_SERVICE "com.nokia.moobox"
#define APP_METHOD "/com/nokia/moobox"
/* end defines */

static int down=0;

static const char *accel_filename = "/sys/class/i2c-adapter/i2c-3/3-001d/coord";

static unsigned int check_orientation_timer = 0; /* Sun Nov 01 16:33:34 2009 lcuk : storage for the timer (needed to know we can remove it) */

static void eos_message_received (GstBus* bus, GstMessage* message, GstElement* pipeline)
{
  /* stop playback and free pipeline */
  gst_element_set_state (pipeline, GST_STATE_NULL);
  gst_object_unref (GST_OBJECT(pipeline));
  pipeline = NULL;
}


static gint play_sound ()
{
	GstElement *pipeline;
	GstElement *filesrc;
	GstBus *bus;
	GError *error = NULL;

	/* we're already playing */
	/*if (appdata->pipeline) return -1;*/

	/* setup pipeline and configure elements */
	pipeline = gst_parse_launch ("filesrc name=my_filesrc ! decodebin ! audioconvert ! audioresample !pulsesink",&error);
	if (!pipeline) {
	  fprintf (stderr, "Parse error: %s\n", error->message);
	  goto error;
	}

	filesrc = gst_bin_get_by_name (GST_BIN (pipeline), "my_filesrc");
	if (!filesrc) {
	  fprintf (stderr, "Parse error: no filesrc\n");
	  goto error;
	}

	g_object_set (G_OBJECT (filesrc), "location", "/opt/moobox/media/Moo.mp3", NULL);

	/* setup message handling */
	bus = gst_pipeline_get_bus (GST_PIPELINE (pipeline));
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_HIGH);
	g_signal_connect (bus, "message::eos", (GCallback) eos_message_received,pipeline);
	gst_object_unref (GST_OBJECT(bus));

	/* start playback */
	gst_element_set_state (pipeline, GST_STATE_PLAYING);
	return 0;

	error:
	  gst_object_unref (GST_OBJECT(pipeline));
	  pipeline = NULL;
	  return -1;
}

static gint
dbus_callback (const gchar *interface, const gchar *method,
               GArray *arguments, gpointer data,
               osso_rpc_t *retval)
{
  printf ("dbus: %s, %s\n", interface, method);

  if (!strcmp (method, "top_application"))
      gtk_window_present (GTK_WINDOW (data));

  return DBUS_TYPE_INVALID;
}

/* Read the accelerometer value - taken from liqaccel.c */
int orientation_read(int *ax,int *ay,int *az)
{
	FILE *fd;
	int rs;

	fd = fopen(accel_filename, "r");
	if(fd==NULL){ fprintf(stderr, "orientation_read, cannot open for reading"); return -1;}
	rs=fscanf((FILE*) fd,"%i %i %i",ax,ay,az);
	fclose(fd);
	if(rs != 3){ fprintf(stderr, "orientation_read, cannot read information"); return -2;}

	return 0;
}

static int check_orientation(gpointer data){
	int x, y, z, res;

	res=orientation_read(&x, &y, &z);

	if ((down==0) && (x>=700)){
		down=1;
	}
	else if ((down==1) && (x<=-700)) {
		down=0;
		play_sound();
	}
	return 1;
}



/* Sun Nov 01 16:35:54 2009 lcuk : added event handlers for focus */

static gint GTKFocus_In_Handler(GtkWidget *SrcWidget,GdkEventFocus *Event,gpointer Arg)
{
    /* got focus, lets make sure the timer is running */
    if(!check_orientation_timer)
    {
        check_orientation_timer = g_timeout_add(200, check_orientation, NULL);
    }
    return 0;
}
static gint GTKFocus_Out_Handler(GtkWidget *SrcWidget,GdkEventFocus *Event,gpointer Arg)
{
    /* focusing out, lets make sure we shut down the timer if its running */
    if(check_orientation_timer)
    {
        g_source_remove(check_orientation_timer);
        check_orientation_timer=0;
    }
    return 0;
}


int main( int argc, char* argv[] )
{
    /* Create needed variables */
    HildonProgram *program;
    HildonWindow *window;
    GtkWidget *image;
    osso_context_t *osso_cont;
	osso_return_t ret;

	locale_init();

    osso_cont = osso_initialize(APP_NAME, APP_VER, TRUE, NULL);
	if (osso_cont == NULL)
    {
    	fprintf (stderr, "osso_initialize failed.\n");
    	exit (1);
    }

    /* Initialize the GTK. */
    gtk_init( &argc, &argv );
    /* Init gst */
    gst_init(&argc, &argv);

    /* Create the hildon program and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("MooBox");

    /* Create HildonWindow and set it to HildonProgram */
    window = HILDON_WINDOW(hildon_window_new());
    hildon_program_add_window(program, window);

    /* Quit program when window is closed. */
    g_signal_connect (G_OBJECT (window), "delete_event",
		      G_CALLBACK (gtk_main_quit), NULL);

    /* Quit program when window is otherwise destroyed. */
    g_signal_connect (G_OBJECT (window), "destroy",
		      G_CALLBACK (gtk_main_quit), NULL);

    /* Create button and add it to main view */
    image = gtk_image_new_from_file("/opt/moobox/media/Moo.png");
    gtk_container_add(GTK_CONTAINER(window),
                      image);

    ret = osso_rpc_set_cb_f (osso_cont,
                           APP_SERVICE,
                           APP_METHOD,
                           APP_SERVICE,
                           dbus_callback, GTK_WIDGET( window ));
	if (ret != OSSO_OK) {
		fprintf (stderr, "osso_rpc_set_cb_f failed: %d.\n", ret);
	    exit (1);
	}

    /* Sun Nov 01 16:29:54 2009 lcuk : adding focusin/out events to only set the timer when ontop */
    /* Sun Nov 01 16:29:54 2009 lcuk : thanks to RST38H in #maemo */
    g_signal_connect(GTK_WIDGET(window),"focus_in_event",G_CALLBACK(GTKFocus_In_Handler),0);
    g_signal_connect(GTK_WIDGET(window),"focus_out_event",G_CALLBACK(GTKFocus_Out_Handler),0);


    /* Begin the main application */
    gtk_widget_show_all ( GTK_WIDGET ( window ) );

    gtk_main();

    /* Exit */
    return 0;
}
