/*
 * status-plugin.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __STATUS_PLUGIN_H__
#define __STATUS_PLUGIN_H__

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define MONORAIL_TYPE_STATUS_PLUGIN (monorail_status_plugin_get_type ())
#define MONORAIL_STATUS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONORAIL_TYPE_STATUS_PLUGIN, \
      MonorailStatusPlugin))
#define MONORAIL_STATUS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass),MONORAIL_TYPE_STATUS_PLUGIN, \
      MonorailStatusPluginClass))
#define IS_MONORAIL_STATUS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MONORAIL_TYPE_STATUS_PLUGIN))
#define IS_MONORAIL_STATUS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), MONORAIL_TYPE_STATUS_PLUGIN))
#define MONORAIL_STATUS_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),  MONORAIL_TYPE_STATUS_PLUGIN, \
      MonorailStatusPluginClass))

typedef struct _MonorailStatusPlugin MonorailStatusPlugin;
typedef struct _MonorailStatusPluginClass MonorailStatusPluginClass;
typedef struct _MonorailStatusPluginPrivate MonorailStatusPluginPrivate;

struct _MonorailStatusPlugin
{
  HDStatusMenuItem parent;

  MonorailStatusPluginPrivate *priv;
};

struct _MonorailStatusPluginClass
{
  HDStatusMenuItemClass parent;
};

GType monorail_status_plugin_get_type (void);

G_END_DECLS

#endif /* __STATUS_PLUGIN_H__ */
