/*
 * send.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __SEND_H__
#define __SEND_H__

#include <glib-object.h>

#include "extensions/extensions.h"

G_BEGIN_DECLS

typedef struct _MonorailSend MonorailSend;
typedef struct _MonorailSendClass MonorailSendClass;

#define MONORAIL_TYPE_SEND (monorail_send_get_type ())
#define MONORAIL_SEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONORAIL_TYPE_SEND, MonorailSend))
#define MONORAIL_SEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), MONORAIL_TYPE_SEND, \
      MonorailSendClass))
#define MONORAIL_IS_SEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MONORAIL_TYPE_SEND))
#define MONORAIL_IS_SEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MONORAIL_TYPE_SEND))
#define MONORAIL_SEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), MONORAIL_TYPE_SEND, \
      MonorailSendClass))

struct _MonorailSend
{
  GObject parent;
};

struct _MonorailSendClass
{
  GObjectClass parent_class;
};

GType monorail_send_get_type (void);

MonorailSend * monorail_send_new (void);

G_END_DECLS

#endif /* __SEND_H__ */
