/*
 * send.c
 *
 * Copyright (C) 2009-2010 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <telepathy-glib/dbus.h>

#include "debug.h"
#include "send.h"

static void send_iface_init (MonorailSvcSendClass *klass);

G_DEFINE_TYPE_WITH_CODE (MonorailSend, monorail_send, G_TYPE_OBJECT,
    G_IMPLEMENT_INTERFACE (MONORAIL_TYPE_SVC_SEND,
        send_iface_init));

enum /* signals */
{
  SEND_FILES,
  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0, };

static void
monorail_send_constructed (GObject *object)
{
  TpDBusDaemon *dbus_daemon;

  dbus_daemon = tp_dbus_daemon_dup (NULL);

  if (dbus_daemon != NULL)
    {
      dbus_g_connection_register_g_object (
          tp_proxy_get_dbus_connection (dbus_daemon),
          "/org/maemo/Monorail/Send", object);

      g_object_unref (dbus_daemon);
    }
}

static void
monorail_send_class_init (MonorailSendClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->constructed = monorail_send_constructed;

  signals[SEND_FILES] = g_signal_new ("send-files",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__POINTER,
      G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
monorail_send_send_multiple (MonorailSvcSend *self,
    const gchar **filenames,
    DBusGMethodInvocation *context)
{
  MonorailSend *send = MONORAIL_SEND (self);
  DEBUG ("SendMultiple");

  g_signal_emit (send, signals[SEND_FILES], 0, filenames, NULL);

  monorail_svc_send_return_from_send_multiple (context);
}

static void
send_iface_init (MonorailSvcSendClass *klass)
{
  monorail_svc_send_implement_send_multiple(klass,
      monorail_send_send_multiple);
}

static void
monorail_send_init (MonorailSend *self)
{
}

MonorailSend *
monorail_send_new (void)
{
  return g_object_new (MONORAIL_TYPE_SEND, NULL);
}

