/*
 * notify.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __NOTIFY_H__
#define __NOTIFY_H__

#include <glib-object.h>

#include "extensions/extensions.h"

G_BEGIN_DECLS

typedef struct _MonorailNotify MonorailNotify;
typedef struct _MonorailNotifyClass MonorailNotifyClass;

#define MONORAIL_TYPE_NOTIFY (monorail_notify_get_type ())
#define MONORAIL_NOTIFY(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), MONORAIL_TYPE_NOTIFY, MonorailNotify))
#define MONORAIL_NOTIFY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), MONORAIL_TYPE_NOTIFY, \
      MonorailNotifyClass))
#define MONORAIL_IS_NOTIFY(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MONORAIL_TYPE_NOTIFY))
#define MONORAIL_IS_NOTIFY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MONORAIL_TYPE_NOTIFY))
#define MONORAIL_NOTIFY_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), MONORAIL_TYPE_NOTIFY, \
      MonorailNotifyClass))

struct _MonorailNotify
{
  GObject parent;
};

struct _MonorailNotifyClass
{
  GObjectClass parent_class;
};

GType monorail_notify_get_type (void);

MonorailNotify * monorail_notify_new (void);

void monorail_notify_update_num_transfers (MonorailNotify *notify,
    guint transfers);

G_END_DECLS

#endif /* __NOTIFY_H__ */
