/*
 * monorail.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

#include <libosso-abook/osso-abook.h>

#include "monorail-handler.h"
#include "notify.h"
#include "send.h"

#ifndef __MONORAIL_H__
#define __MONORAIL_H__

#define EMPATHY_GET_PRIV(obj,type) ((type##Priv *) ((type *) obj)->priv)
#define empathy_time_get_current() (time (NULL))
#define EMP_STR_EMPTY(x) ((x) == NULL || (x)[0] == '\0')
#define MONORAIL_CLIENT_NAME "Monorail"

typedef struct
{
  MonorailHandler *handler;
  MonorailNotify *notify;
  MonorailSend *send;

  GtkWidget *contact_window;

  gboolean no_ui;
  guint quit_timeout_id;
  guint transfers;
  guint active_transfers;
  /* TransfersData* */
  gpointer transfers_data;
} MonorailData;

void monorail_transfers_inc (MonorailData *data, gboolean fire_signal);
void monorail_transfers_dec (MonorailData *data, gboolean fire_signal);

#endif
