/*
 * transfer.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "monorail.h"
#include "empathy-ft-handler.h"

#ifndef __TRANSFER_H__
#define __TRANSFER_H__

typedef struct
{
  MonorailData *monorail_data;
  GtkWidget *dialog;
  GtkListStore *store;
  GtkWidget *view;
  GtkWidget *pannable_area;
  GtkWidget *no_transfers_label;
  gboolean view_visible;
  guint num_transfers;
  gint x;
  gint y;
} TransfersData;

void transfer_new_handler (MonorailHandler *handler,
    EmpathyFTHandler *ft_handler, MonorailData *monorail_data);

void transfer_show_window (MonorailData *monorail_data);

void transfers_data_free (TransfersData *data);

#endif
