/*
 * notify.c
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <telepathy-glib/dbus.h>

#include "debug.h"
#include "notify.h"

static void notifications_iface_init (MonorailSvcNotificationsClass *klass);

G_DEFINE_TYPE_WITH_CODE (MonorailNotify, monorail_notify, G_TYPE_OBJECT,
    G_IMPLEMENT_INTERFACE (MONORAIL_TYPE_SVC_NOTIFICATIONS,
        notifications_iface_init));

enum /* signals */
{
  SHOW_TRANSFERS,
  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0, };

static void
monorail_notify_constructed (GObject *object)
{
  TpDBusDaemon *dbus_daemon;

  dbus_daemon = tp_dbus_daemon_dup (NULL);

  if (dbus_daemon != NULL)
    {
      dbus_g_connection_register_g_object (
          tp_proxy_get_dbus_connection (dbus_daemon),
          "/org/maemo/Monorail/Notifications", object);

      g_object_unref (dbus_daemon);
    }
}

static void
monorail_notify_class_init (MonorailNotifyClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->constructed = monorail_notify_constructed;

  signals[SHOW_TRANSFERS] = g_signal_new ("show-transfers",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE, 0);
}

static void
monorail_notify_show_transfers (MonorailSvcNotifications *self,
    DBusGMethodInvocation *context)
{
  MonorailNotify *notify = MONORAIL_NOTIFY (self);
  DEBUG ("ShowTransfers");

  g_signal_emit (notify, signals[SHOW_TRANSFERS], 0, NULL);

  monorail_svc_notifications_return_from_show_transfers (context);
}

static void
notifications_iface_init (MonorailSvcNotificationsClass *klass)
{
  monorail_svc_notifications_implement_show_transfers (klass,
      monorail_notify_show_transfers);
}

static void
monorail_notify_init (MonorailNotify *self)
{
}

MonorailNotify *
monorail_notify_new (void)
{
  return g_object_new (MONORAIL_TYPE_NOTIFY, NULL);
}

void
monorail_notify_update_num_transfers (MonorailNotify *notify,
    guint transfers)
{
  monorail_svc_notifications_emit_num_transfers_changed (notify, transfers);
}
